<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_journal_settings', 'jset_rvrisubmission_type')) {
                DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_rvrisubmission_type` VARCHAR(6) NOT NULL COMMENT 'auto or manual' AFTER `jset_research_integrity`");
            }
            if (!Schema::hasColumn('tbk_journal_settings', 'jset_rvrisubmission_type')) {
                DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_rvrisubmission_type` VARCHAR(6) NOT NULL COMMENT 'auto or manual' AFTER `jset_research_integrity`");
            }

            if (!Schema::hasColumn('rvw_journal_settings', 'jset_rvriauto_submissions')) {
                DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_rvriauto_submissions` MEDIUMTEXT NULL DEFAULT NULL AFTER `jset_rvrisubmission_type`");
            }
            if (!Schema::hasColumn('tbk_journal_settings', 'jset_rvriauto_submissions')) {
                DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_rvriauto_submissions` MEDIUMTEXT NULL DEFAULT NULL AFTER `jset_rvrisubmission_type`");
            }
        }
        catch(\Exception $e)
        {
            Log::warning("Adding new column:jset_rvrisubmission_type/jset_rvriauto_submissions failed in article type settings table");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_rvrisubmission_type')) {
            DB::statement("ALTER TABLE `rvw_journal_settings` DROP `jset_rvrisubmission_type`");
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_rvrisubmission_type')) {
            DB::statement("ALTER TABLE `tbk_journal_settings` DROP `jset_rvrisubmission_type`");
        }

        if (Schema::hasColumn('rvw_journal_settings', 'jset_rvriauto_submissions')) {
            DB::statement("ALTER TABLE `rvw_journal_settings` DROP `jset_rvriauto_submissions`");
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_rvriauto_submissions')) {
            DB::statement("ALTER TABLE `tbk_journal_settings` DROP `jset_rvriauto_submissions`");
        }
    }
};
