<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_super_sudo_users');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_super_sudo_users', function (Blueprint $table) {
                $table->id('su_usr_id');
                $table->string('su_usr_username', 250);
                $table->string('su_usr_email', 250);
                $table->string('su_usr_password_hash', 250);
                $table->string('su_usr_first_name', 250);
                $table->string('su_usr_middle_name', 250)->nullable();
                $table->string('su_usr_last_name', 250);
                $table->char('su_usr_status', 1);
                $table->unsignedBigInteger('su_usr_posted_by');
                $table->dateTime('su_usr_posted_date');
                $table->unsignedBigInteger('su_usr_proxy_id')->nullable();
                $table->char('su_usr_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
