<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Task #378 Unsubscribe Link Not Working
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_unsuscribe_email');
        if (!$table_exist) {
            Schema::create('rvw_unsuscribe_email', function (Blueprint $table) {
                $table->bigIncrements('usl_id'); // Auto-incrementing primary key
                $table->bigInteger('usl_user_id');
                $table->string('usl_email', 100)->unique(); // Unique field
                $table->char('usl_cc_status', 1)->default('n')->comment('y-yes,n-no'); // Status field with default value
                $table->char('usl_status', 1)->default('y')->comment('y-yes,n-no'); // Status field with default value
                $table->bigInteger('usl_esl_batch_id');	
                $table->string('usl_comments');	
                $table->dateTime('usl_posted_date')->nullable(); // Nullable datetime field
                $table->bigInteger('usl_posted_by'); // Posted by field
                $table->bigInteger('usl_proxy_id')->nullable(); // Nullable proxy ID field
                $table->char('usl_operation', 1); // Operation field
            });
        }
        $table_exist = Schema::connection('mysql_common')->hasTable('tbk_unsuscribe_email');
        if (!$table_exist) {
            Schema::create('tbk_unsuscribe_email', function (Blueprint $table) {
                $table->bigInteger('usl_id'); // Auto-incrementing primary key
                $table->bigInteger('usl_user_id');
                $table->string('usl_email', 100)->unique(); // Unique field
                $table->char('usl_cc_status', 1)->default('n')->comment('y-yes,n-no'); // Status field with default value
                $table->char('usl_status', 1)->default('y')->comment('y-yes,n-no'); // Status field with default value
                $table->bigInteger('usl_esl_batch_id');	
                $table->string('usl_comments');	
                $table->dateTime('usl_posted_date')->nullable(); // Nullable datetime field
                $table->bigInteger('usl_posted_by'); // Posted by field
                $table->bigInteger('usl_proxy_id')->nullable(); // Nullable proxy ID field
                $table->char('usl_operation', 1); // Operation field
                $table->bigIncrements('tbk_id'); // Operation field
            });
        }
        DB::unprepared('
        CREATE TRIGGER trg_unsuscribe_email_after_insert AFTER INSERT ON `rvw_unsuscribe_email` FOR EACH ROW
        BEGIN
        INSERT INTO tbk_unsuscribe_email SELECT *,NULL tbk_id FROM rvw_unsuscribe_email WHERE usl_id= NEW.usl_id;
        END
        ');
        DB::unprepared("
        CREATE TRIGGER trg_unsuscribe_email_after_update AFTER UPDATE ON `rvw_unsuscribe_email` FOR EACH ROW
        BEGIN
        IF NEW.usl_operation != 'm'  THEN 
        INSERT INTO tbk_unsuscribe_email SELECT *,NULL tbk_id FROM rvw_unsuscribe_email WHERE usl_id= OLD.usl_id;
        END IF;
        END
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_unsuscribe_email');
        Schema::dropIfExists('tbk_unsuscribe_email');
    }
};
