<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_modules');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_client_modules', function (Blueprint $table) {
                $table->id('cm_id');
                $table->string('cm_name', 50);
                $table->text('cm_description')->nullable();
                $table->char('cm_status', 1);
                $table->unsignedBigInteger('cm_posted_by');
                $table->dateTime('cm_posted_date');
                $table->unsignedBigInteger('cm_proxy_id')->nullable();
                $table->char('cm_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
