<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            // Check if the column exists before attempting to change structure
            $columnExists1 = DB::select("SHOW COLUMNS FROM rvw_research_integrity_reports LIKE 'rri_aflw_id'");
            if ($columnExists1) {
                DB::statement("ALTER TABLE `rvw_research_integrity_reports` CHANGE `rri_aflw_id` `rri_aflw_id` BIGINT UNSIGNED NULL DEFAULT NULL;");
                DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD  CONSTRAINT `FK_rri_aflw_id` FOREIGN KEY (`rri_aflw_id`) REFERENCES `rvw_article_flow`(`aflw_id`) ON DELETE CASCADE ON UPDATE RESTRICT;");
            }

            // Check if the column exists before attempting to change structure
            $columnExists2 = DB::select("SHOW COLUMNS FROM tbk_research_integrity_reports LIKE 'rri_art_id'");
            if ($columnExists2) {
                DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD CONSTRAINT `FK_rri_art_id` FOREIGN KEY (`rri_art_id`) REFERENCES `rvw_articles`(`art_id`) ON DELETE CASCADE ON UPDATE RESTRICT;");
            }
        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
