<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_user_feedback', function (Blueprint $table) {
            // Change columns to MEDIUMTEXT and nullable with default NULL
            $table->mediumText('fd_cc_email_id')
                ->nullable()
                ->default(null)
                ->change();

            $table->mediumText('fd_bcc_email_id')
                ->nullable()
                ->default(null)
                ->change();

            $table->mediumText('fd_to_email')
                ->nullable()
                ->default(null)
                ->change();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_user_feedback', function (Blueprint $table) {
            // Reverse the changes - you may want to adjust these to the original data types
            $table->text('fd_cc_email_id')->change();
            $table->text('fd_bcc_email_id')->change();
            $table->text('fd_to_email')->change();
        });
    }
};