<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('rvw_common_optional_select_colums')) {
            Schema::create('rvw_common_optional_select_colums', function (Blueprint $table) {
                $table->bigIncrements('cosc_id');
                $table->bigInteger('cosc_user_id');
                $table->bigInteger('cosc_jnl_id');
                $table->json('cosc_colums');
                $table->bigInteger('cosc_posted_by');
                $table->dateTime('cosc_posted_date');
                $table->bigInteger('cosc_proxy_id');
                $table->char('cosc_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
            });
        }
        if (!Schema::hasTable('tbk_common_optional_select_colums')) {
            Schema::create('tbk_common_optional_select_colums', function (Blueprint $table) {
                $table->bigInteger('cosc_id');
                $table->bigInteger('cosc_user_id');
                $table->bigInteger('cosc_jnl_id');
                $table->json('cosc_colums');
                $table->bigInteger('cosc_posted_by');
                $table->dateTime('cosc_posted_date');
                $table->bigInteger('cosc_proxy_id');
                $table->char('cosc_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
                $table->bigIncrements('tbk_id');
            });
        }

        DB::unprepared("CREATE TRIGGER trg_rvw_common_optional_select_colums_after_insert AFTER INSERT ON `rvw_common_optional_select_colums` FOR EACH ROW BEGIN INSERT INTO `tbk_common_optional_select_colums` SELECT *, NULL AS tbk_id FROM `rvw_common_optional_select_colums` WHERE `cosc_id` = NEW.`cosc_id`; END;");

        DB::unprepared("CREATE TRIGGER trg_rvw_common_optional_select_colums_after_update AFTER UPDATE ON `rvw_common_optional_select_colums` FOR EACH ROW BEGIN INSERT INTO `tbk_common_optional_select_colums` SELECT *, NULL AS tbk_id FROM `rvw_common_optional_select_colums` WHERE `cosc_id` = OLD.`cosc_id`; END;");

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rvw_common_optional_select_colums');
        Schema::dropIfExists('tbk_common_optional_select_colums');
    }
};
