<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            if (!Schema::hasColumn('rvw_journal_settings', 'jset_manage_production_article')) {
                DB::statement("
                    ALTER TABLE `rvw_journal_settings` 
                    ADD `jset_manage_production_article` MEDIUMTEXT 
                    CHARACTER SET utf8mb4 
                    COLLATE utf8mb4_unicode_ci 
                    NULL DEFAULT NULL 
                    COMMENT 'who can submit article for production' 
                    AFTER `jset_manage_article_type`
                ");
            }

            if (!Schema::hasColumn('tbk_journal_settings', 'jset_manage_production_article')) {
                DB::statement("
                    ALTER TABLE `tbk_journal_settings` 
                    ADD `jset_manage_production_article` MEDIUMTEXT 
                    CHARACTER SET utf8mb4 
                    COLLATE utf8mb4_unicode_ci 
                    NULL DEFAULT NULL 
                    COMMENT 'who can submit article for production' 
                    AFTER `jset_manage_article_type`
                ");
            }
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_manage_production_article')) {
            Schema::table('rvw_journal_settings', function ($table) {
                $table->dropColumn('jset_manage_production_article');
            });
        }

        if (Schema::hasColumn('tbk_journal_settings', 'jset_manage_production_article')) {
            Schema::table('tbk_journal_settings', function ($table) {
                $table->dropColumn('jset_manage_production_article');
            });
        }
    }
};