<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
          if (!Schema::hasColumn('rvw_articles', 'art_drafted_by')) {
        Schema::table('rvw_articles', function (Blueprint $table) {
            $table->unsignedBigInteger('art_drafted_by')
                ->nullable()
                ->comment('article created by')
                ->after('art_no_of_tables');
        });
    }

    if (!Schema::hasColumn('tbk_articles', 'art_drafted_by')) {
        Schema::table('tbk_articles', function (Blueprint $table) {
            $table->unsignedBigInteger('art_drafted_by')
                ->nullable()
                ->comment('article created by')
                ->after('art_no_of_tables');
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      Schema::table('rvw_articles', function (Blueprint $table) {
            $table->dropColumn('art_drafted_by');
        });;
             Schema::table('tbk_articles', function (Blueprint $table) {
            $table->dropColumn('art_drafted_by');
        });
    }
};
