<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $journals = DB::table('rvw_journals')->get();

        foreach ($journals as $journal) {
            $code     = $journal->jnl_journal_code;
            $table    = 'article_gnf_form_data_' . $code;
            $tbkTable = 'tbk_' . $table;
            $rvwTable = 'rvw_' . $table;
            $key      = 'gdata_id';

            // 1. Add tbk_id column (auto-increment PK)
        if (Schema::hasTable($tbkTable) && Schema::hasTable($rvwTable)) {
           if (!Schema::hasColumn($tbkTable, 'tbk_id')) {
                Schema::table($tbkTable, function (Blueprint $t) {
                    $t->bigIncrements('tbk_id');
                });
            }

          if (Schema::hasColumn($tbkTable, 'operation') && Schema::hasColumn($tbkTable, 'actiontime')) {
                DB::table($tbkTable)
                    ->update([
                        'gdata_operation'   => DB::raw('operation'),
                        'gdata_posted_date' => DB::raw('actiontime'),
                    ]);

                // Drop old columns safely
                Schema::table($tbkTable, function (Blueprint $t) {
                    if (Schema::hasColumn($t->getTable(), 'operation')) $t->dropColumn('operation');
                    if (Schema::hasColumn($t->getTable(), 'actiontime')) $t->dropColumn('actiontime');
                });
            }
            // 4. Drop old triggers (if exist)
            DB::unprepared("DROP TRIGGER IF EXISTS `trg_rvw_{$table}_after_insert`;");
            DB::unprepared("DROP TRIGGER IF EXISTS `trg_rvw_{$table}_after_update`;");
            DB::unprepared("DROP TRIGGER IF EXISTS `trg_rvw_{$table}_before_delete`;");

            // 5. AFTER INSERT trigger
            $afterInsertTrigger = <<<SQL
                CREATE TRIGGER `trg_rvw_{$table}_after_insert`
                AFTER INSERT ON `rvw_{$table}`
                FOR EACH ROW
                BEGIN
                    INSERT INTO {$tbkTable}
                    SELECT *, NULL as tbk_id
                    FROM rvw_{$table}
                    WHERE {$key} = NEW.{$key};
                END;
            SQL;

            // 6. AFTER UPDATE trigger
            $afterUpdateTrigger = <<<SQL
                CREATE TRIGGER `trg_rvw_{$table}_after_update`
                AFTER UPDATE ON `rvw_{$table}`
                FOR EACH ROW
                BEGIN
                    IF (NEW.gdata_operation != 'm' AND NEW.gdata_operation != 'e') THEN
                        INSERT INTO {$tbkTable}
                        SELECT *, NULL as tbk_id
                        FROM rvw_{$table}
                        WHERE {$key} = OLD.{$key};
                    END IF;
                END;
            SQL;

            DB::unprepared($afterInsertTrigger);
            DB::unprepared($afterUpdateTrigger);
        }
    }
    }

    public function down(): void
    {
        $journals = DB::table('rvw_journals')->get();

        foreach ($journals as $journal) {
            $table    = 'article_gnf_form_data_' . $journal->jnl_journal_code;
            $tbkTable = 'tbk_' . $table;

            // Restore dropped columns and remove tbk_id
            Schema::table($tbkTable, function (Blueprint $t) {
                $t->char('operation', 1)->nullable();
                $t->timestamp('actiontime')->nullable();
                $t->dropColumn('tbk_id');
            });

            // Drop triggers
            DB::unprepared("DROP TRIGGER IF EXISTS `trg_rvw_{$table}_after_insert`;");
            DB::unprepared("DROP TRIGGER IF EXISTS `trg_rvw_{$table}_after_update`;");
        }
    }
};
