<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->char('jset_controlled_input_keyword', 1)
            ->charset('utf8mb4')
            ->collation('utf8mb4_unicode_ci')
            ->default('n')
            ->after('jset_user_input_keyword');
        });

        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->char('jset_controlled_input_keyword', 1)
            ->charset('utf8mb4')
            ->collation('utf8mb4_unicode_ci')
            ->default('n')
            ->after('jset_user_input_keyword');
        });
    }

    /**
    * Reverse the migrations.
    */
    public function down(): void
    {
        //
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_controlled_input_keyword');
        });
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_controlled_input_keyword');
        });
    }	
};
