<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * /* Task #3249 - Basecamp Ticket: TrAction: Rescind Publish AoP2 stage - start*/
    public function up(): void
    {
          if (!Schema::hasColumn('rvw_journal_settings', 'jset_reopen_milestone_stages')) {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->json('jset_reopen_milestone_stages')
                ->nullable()
                ->comment('Reopen milestone stages.')
                ->after('jset_generic_discussion');
        });
    }

    if (!Schema::hasColumn('tbk_journal_settings', 'jset_reopen_milestone_stages')) {
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->json('jset_reopen_milestone_stages')
                ->nullable()
                ->comment('Reopen milestone stages.')
                ->after('jset_generic_discussion');
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_reopen_milestone_stages');
        });;
             Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_reopen_milestone_stages');
        });
    }
};
