<?php

use App\Http\Controllers\Controller;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try{
            $client_code=(new Controller())->get_client_details('clnt_client_code');
            if($client_code->clnt_client_code=='lepra'){
            DB::statement("CREATE TABLE `rvw_article_folder_move_to_another_server` (
                `afm_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `afm_art_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
                `afm_criteria_date` datetime NOT NULL COMMENT 'if e then final export date , r then article decision date',	
                `afm_status` char(1) COLLATE utf8_unicode_ci NOT NULL COMMENT 'e-exported,r-rejected',
                `afm_posted_by` bigint(20) UNSIGNED NOT NULL,
                `afm_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `afm_posted_date` datetime NOT NULL,
                `afm_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
               PRIMARY KEY (`afm_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
              
              DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_stage_manual_reminder` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'for stage manual reminder' AFTER `jset_view_email_log`");
              DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_stage_manual_reminder` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'for stage manual reminder' AFTER `jset_view_email_log`");
              
              DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_stage_manual_reminder` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'for stage manual reminder' AFTER `atotp_view_email_log`");
              DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_stage_manual_reminder` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'for stage manual reminder' AFTER `atotp_view_email_log`");
              DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_bulk_invite_submission` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permitted users to send bulk author invitation' AFTER `jset_auto_assign_role`");
              
              DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_bulk_invite_submission` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permitted users to send bulk author invitation' AFTER `jset_auto_assign_role`");
              
              DB::statement("DELETE FROM `rvw_email_tmpls` WHERE `etmp_name` ='bulk_invite_submission'");
              DB::insert("INSERT
              INTO
                rvw_email_tmpls(
                  etmp_id,
                  etmp_name,
                  etmp_notification,
                  etmp_cust_to,
                  etmp_cc,
                  etmp_cust_cc,
                  etmp_bcc,
                  etmp_cust_bcc,
                  etmp_content_type,
                  etmp_subject,
                  etmp_email_template,
                  etmp_posted_date,
                  etmp_posted_by,
                  etmp_proxy_id,
                  etmp_operation
                )
              VALUES(
                NULL,
                'bulk_invite_submission',
                'User',
                '',
                '[\'Custom\']',
                '',
                '[\'Custom\']',
                '',
                '',
                'Invitation to Submit to ##JOURNAL_NAME##',
                '<p>Dear Author,</p><p> </p><p>You have been invited by the staff to submit a article in ##JOURNAL_NAME##</p><p>Please click the below link to submit an article before ##TASK_DUE_DATE##:</p><p>##BULK_INVITATION_SUBMISSION## </p><p>Regards,</p><p>Team ReView</p>',
                '2020-11-05 09:15:11',
                1,
                0,
                'u'
              );
              ");
           
              
              DB::statement("CREATE TABLE `rvw_ftp_locations`(
                `ftp_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `ftp_jnl_id` BIGINT(20) UNSIGNED NOT NULL COMMENT 'PK of journal table',
                `ftp_is_default` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y-yes, n-no',
                `ftp_display_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_host_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_user_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_password` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_port` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_location` VARCHAR(100) NOT NULL,
                `ftp_posted_by` BIGINT(20) UNSIGNED NOT NULL,
                `ftp_posted_date` DATETIME NOT NULL,
                `ftp_proxy_id` BIGINT(20) UNSIGNED NOT NULL,
                `ftp_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY(`ftp_id`)
              ) ENGINE = InnoDB;");
              DB::statement("CREATE TABLE `tbk_ftp_locations`(
                `ftp_id` BIGINT(20) UNSIGNED NOT NULL,
                `ftp_jnl_id` BIGINT(20) UNSIGNED NOT NULL COMMENT 'PK of journal table',
                `ftp_is_default` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'y-yes, n-no',
                `ftp_display_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_host_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_user_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_password` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_port` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `ftp_location` VARCHAR(100) NOT NULL,
                `ftp_posted_by` BIGINT(20) UNSIGNED NOT NULL,
                `ftp_posted_date` DATETIME NOT NULL,
                `ftp_proxy_id` BIGINT(20) UNSIGNED NOT NULL,
                `ftp_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `tbk_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT, 
                 PRIMARY KEY (`tbk_id`)
              ) ENGINE = InnoDB;");
               DB::unprepared("DROP TRIGGER IF EXISTS
                `trg_ftp_locations_after_insert`;
              CREATE TRIGGER `trg_ftp_locations_after_insert` AFTER INSERT ON `rvw_ftp_locations`
               FOR EACH ROW INSERT
              INTO
                tbk_ftp_locations
              SELECT
                *,
                NULL tbk_id
              FROM
                rvw_ftp_locations
              WHERE
                ftp_id = NEW.ftp_id");
            DB::unprepared("DROP TRIGGER IF EXISTS trg_ftp_locations_after_update");
            DB::unprepared("CREATE TRIGGER `trg_ftp_locations_after_update` AFTER UPDATE ON `rvw_ftp_locations` FOR EACH ROW BEGIN IF( NEW.ftp_operation != 'm' AND NEW.ftp_operation != 'e' ) THEN INSERT INTO tbk_ftp_locations SELECT *, NULL tbk_id FROM rvw_ftp_locations WHERE ftp_id = OLD.ftp_id ; END IF ; END;");

 DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_author_confirmation_bw_article_types` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'Transfer articles between article types , y-with confirmation , n-without confirmation' AFTER `jset_bulk_invite_submission`");

 DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_author_confirmation_bw_article_types` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'Transfer articles between article types , y-with confirmation , n-without confirmation' AFTER `jset_bulk_invite_submission`");
 DB::statement("ALTER TABLE `rvw_article_transfer_suggestion` ADD `ats_without_au_confirmation_usr_role` INT(10) UNSIGNED NOT NULL COMMENT 'Tansfer completed user role when without athour confirmation' AFTER `ats_author_action`");
 DB::statement("ALTER TABLE `tbk_article_transfer_suggestion` ADD `ats_without_au_confirmation_usr_role` INT(10) UNSIGNED NOT NULL COMMENT 'Tansfer completed user role when without athour confirmation ' AFTER `ats_author_action`");
 
  DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_author_confirmation_jnl` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'Transfer articles to another journal, y-with confirmation , n-without confirmation' AFTER `jset_author_confirmation_bw_article_types`");

 DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_author_confirmation_jnl` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'Transfer articles to another journal , y-with confirmation , n-without confirmation' AFTER `jset_author_confirmation_bw_article_types`");
 DB::insert("INSERT
 INTO
   rvw_email_tmpls(
     etmp_id,
     etmp_name,
     etmp_notification,
     etmp_cust_to,
     etmp_cc,
     etmp_cust_cc,
     etmp_bcc,
     etmp_cust_bcc,
     etmp_content_type,
     etmp_subject,
     etmp_email_template,
     etmp_posted_date,
     etmp_posted_by,
     etmp_proxy_id,
     etmp_operation
   )
 VALUES(
   NULL,
   'transfer_article_without_author_confirmation_resubmit',
   'User',
   '',
   '',
   '',
   '',
   '',
   '',
   'Transfer Article Without Author Confirmation Resubmit',
   '<p>Dear ##RECIPIENT_TITLE## ##RECIPIENT_FULLNAME##,</p><p>Your article ##ARTICLE_ID## has been transfered to ##DESTINATION_JOURNAL## as a ##DESTINATION_ARTICLE_TYPE##.</p><p>##NOTES_TO_AUTHOR##</p><p>Please login and resubmit :##DESTINATION_ARTICLE_STATUS_LINK## </p><p>Best regards,</p><p>Editorial Office<br> ##SENDING_JOURNAL##</p>',
   '2020-11-05 09:15:11',
   1,
   0,
   'u'
 )");
 DB::insert("INSERT
 INTO
   rvw_email_tmpls(
     etmp_id,
     etmp_name,
     etmp_notification,
     etmp_cust_to,
     etmp_cc,
     etmp_cust_cc,
     etmp_bcc,
     etmp_cust_bcc,
     etmp_content_type,
     etmp_subject,
     etmp_email_template,
     etmp_posted_date,
     etmp_posted_by,
     etmp_proxy_id,
     etmp_operation
   )
 VALUES(
   NULL,
   'transfer_article_without_confirmation',
   'User',
   '',
   '',
   '',
   '',
   '',
   '',
   'Transfer Article Without Author Confirmation',
   '<p>Dear ##RECIPIENT_TITLE## ##RECIPIENT_FULLNAME##,</p><p>Your article ##ARTICLE_ID## has been transfered to ##DESTINATION_JOURNAL## as a ##DESTINATION_ARTICLE_TYPE##.</p><p>##NOTES_TO_AUTHOR##</p><p> </p><p>Best regards,</p><p>Editorial Office<br> ##SENDING_JOURNAL##</p>',
   '2020-11-05 09:15:11',
   1,
   0,
   'u'
 )");
 
DB::statement("CREATE TABLE `rvw_events` (
    `event_id` bigint(20) NOT NULL AUTO_INCREMENT,
    `event_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    `event_due_date` date NOT NULL,
    `event_journal_id` int(11) DEFAULT NULL,
    `event_type` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'i=invitation submission, c=conference',
    `event_posted_by` bigint(20) NOT NULL,
    `event_posted_date` datetime NOT NULL,
    `event_proxy_id` bigint(20) NOT NULL,
    `event_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY(`event_id`)
  ) ENGINE=InnoDB");  
DB::statement("CREATE TABLE `rvw_event_invited_users` (
    `evu_id` bigint(20) NOT NULL AUTO_INCREMENT,
    `evu_event_id` bigint(20) NOT NULL,
    `evu_user_id` bigint(20) DEFAULT NULL,
    `evu_user_email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
    `evu_registration_usr_id` bigint(20) DEFAULT NULL,
    `evu_submit_status` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'i' COMMENT 'i=invited,d=draft,s=submitted',
    `evu_art_id` bigint(20) DEFAULT NULL,
    `evu_posted_by` bigint(20) NOT NULL,
    `evu_posted_date` datetime NOT NULL,
    `evu_proxy_id` bigint(20) NOT NULL,
    `evu_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY(`evu_id`)
  ) ENGINE=InnoDB");
DB::statement("ALTER TABLE `rvw_event_invited_users`
ADD CONSTRAINT `rvw_event_invited_users_ibfk_1` FOREIGN KEY (`evu_event_id`) REFERENCES `rvw_events` (`event_id`)");
DB::statement("ALTER TABLE
`rvw_ftp_locations` ADD `ftp_jwf_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_journal_workflows' AFTER `ftp_jnl_id`,
ADD `ftp_event_type` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'i - on stage initize, c - on stage complete' AFTER `ftp_jwf_id`");
 DB::statement("ALTER TABLE
 `tbk_ftp_locations` ADD `ftp_jwf_id` BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_journal_workflows' AFTER `ftp_jnl_id`,
 ADD `ftp_event_type` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'i - on stage initize, c - on stage complete' AFTER `ftp_jwf_id`");
 DB::statement("ALTER TABLE `rvw_ftp_locations` CHANGE `ftp_is_default` `ftp_is_default` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'is_default :-y-yes, n-no check for jnl_settings, is_enable check for article workflow'");
 DB::insert("INSERT
 INTO
   rvw_email_tmpls(
     etmp_id,
     etmp_name,
     etmp_notification,
     etmp_cust_to,
     etmp_cc,
     etmp_cust_cc,
     etmp_bcc,
     etmp_cust_bcc,
     etmp_content_type,
     etmp_subject,
     etmp_email_template,
     etmp_posted_date,
     etmp_posted_by,
     etmp_proxy_id,
     etmp_operation
   )
 VALUES(
   NULL,
   'bulk_invite_reminder',
   'User',
   '',
   '[\"Custom\"]',
   '',
   '[\"Custom\"]',
   '',
   '',
   'Reminder to Submit to ##JOURNAL_NAME##',
   '<p>Dear Author,</p><p>This is a reminder to submit a article in ##JOURNAL_NAME##</p><p>Please click the below link to submit an article before ##TASK_DUE_DATE##:</p><p>##BULK_INVITATION_SUBMISSION## </p><p>Regards,</p><p>Team ReView</p>',
   '2020-12-02 09:15:11',
   1,
   0,
   'u'
 )");
DB::statement("CREATE TABLE `rvw_advance_flow_movement` (
    `afm_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    `afm_jwf_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - partent stage id',
    `afm_fwm_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_flow_master_id',
    `afm_associated_stage_ids` text COLLATE utf8_unicode_ci NOT NULL,
    `afm_button_title` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
    `afm_button_tooltip` varchar(125) COLLATE utf8_unicode_ci DEFAULT NULL,
    `afm_posted_by` bigint(20) UNSIGNED NOT NULL,
    `afm_posted_date` datetime NOT NULL, 
    `afm_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
    `afm_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
   PRIMARY KEY (`afm_id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
  
  DB::statement("CREATE TABLE `tbk_advance_flow_movement` (
    `afm_id` bigint(20) UNSIGNED NOT NULL,
    `afm_jwf_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - partent stage id',
    `afm_fwm_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_flow_master_id',
    `afm_associated_stage_ids` text COLLATE utf8_unicode_ci NOT NULL,
    `afm_button_title` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
    `afm_button_tooltip` varchar(125) COLLATE utf8_unicode_ci DEFAULT NULL,
    `afm_posted_by` bigint(20) UNSIGNED NOT NULL,
    `afm_posted_date` datetime NOT NULL, 
    `afm_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
    `afm_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
   PRIMARY KEY (`tbk_id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
  DB::unprepared("drop trigger if exists trg_advance_flow_movement_after_insert; CREATE TRIGGER trg_advance_flow_movement_after_insert  AFTER INSERT ON rvw_advance_flow_movement FOR EACH ROW INSERT INTO tbk_advance_flow_movement SELECT *,NULL tbk_id FROM rvw_advance_flow_movement WHERE afm_id= NEW.afm_id");

  DB::unprepared("drop trigger if exists trg_advance_flow_movement_after_update; CREATE TRIGGER trg_advance_flow_movement_after_update  AFTER UPDATE ON rvw_advance_flow_movement FOR EACH ROW INSERT INTO tbk_advance_flow_movement SELECT *,NULL tbk_id FROM rvw_advance_flow_movement WHERE afm_id= OLD.afm_id");
  DB::statement("ALTER TABLE `rvw_advance_flow_movement` ADD INDEX(`afm_jwf_id`)");
  DB::statement("ALTER TABLE `rvw_advance_flow_movement` ADD INDEX(`afm_fwm_id`)");

  DB::statement("ALTER TABLE `rvw_advance_flow_movement` ADD FOREIGN KEY (`afm_jwf_id`) REFERENCES `rvw_journal_workflows`(`jwf_id`) ON DELETE CASCADE ON UPDATE CASCADE");
  DB::statement("ALTER TABLE `rvw_advance_flow_movement` ADD FOREIGN KEY (`afm_fwm_id`) REFERENCES `rvw_flow_master`(`fwm_id`) ON DELETE CASCADE ON UPDATE CASCADE");
  DB::statement("ALTER TABLE `rvw_journal_workflows` ADD `jwf_production_upload` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n = not required/o = optional/r = required' AFTER `jwf_enable_popup_after_completion`");

  DB::statement("ALTER TABLE `tbk_journal_workflows` ADD `jwf_production_upload` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n = not required/o = optional/r = required' AFTER `jwf_enable_popup_after_completion`");
  DB::statement("ALTER TABLE `rvw_articles` ADD `art_submitted_current_stage` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'current stage of submitted article' AFTER `art_new_submission`");

  DB::statement("ALTER TABLE `tbk_articles` ADD `art_submitted_current_stage` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'current stage of submitted article' AFTER `art_new_submission`");
  DB::statement("ALTER TABLE `rvw_articles` ADD `art_stage_submission_method` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o' COMMENT 'artice stage submission method Normal n, zip by stage submission z ,Default o' AFTER art_submitted_current_stage");

  DB::statement("ALTER TABLE `tbk_articles` ADD `art_stage_submission_method` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o' COMMENT 'artice stage submission method Normal n, zip by stage submission z ,Default o' AFTER `art_submitted_current_stage`");
  DB::statement("ALTER TABLE `rvw_author_affiliation` ADD `auaff_single_affiliation` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'author affilation  single sentence' AFTER `auaff_type`");

  DB::statement("ALTER TABLE `tbk_author_affiliation` ADD `auaff_single_affiliation` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'author affilation  single sentence' AFTER `auaff_type`");
 // DB::statement("ALTER TABLE `tbk_attachment_file_description` ADD `afdec_exclude_file` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-yes,n-no' AFTER `afdec_file_type_id`");
  DB::statement("ALTER TABLE rvw_journal_workflows ADD jwf_button_title VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER jwf_production_upload");

  DB::statement("ALTER TABLE tbk_journal_workflows ADD jwf_button_title VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER jwf_production_upload");
  DB::statement("ALTER TABLE `rvw_journals` ADD `jnl_article_submission_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=can submit articles,n=cannot submit articles' AFTER `jnl_orcid_group_put_code`");

  DB::statement("ALTER TABLE `tbk_journals` ADD `jnl_article_submission_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=can submit articles,n=cannot submit articles' AFTER `jnl_orcid_group_put_code`");
  DB::statement("ALTER TABLE `rvw_article_legacydata` ADD `arld_article_abstract` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER `arld_article_title`");
  DB::statement("ALTER TABLE `rvw_legacy_article_author_list` ADD `lauth_institution` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `lauth_submission_date`, ADD `lauth_institution_id` BIGINT NULL AFTER `lauth_institution`, ADD `lauth_address` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `lauth_institution_id`, ADD `lauth_zip` VARCHAR(50) NULL DEFAULT NULL AFTER `lauth_address`, ADD `lauth_city` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `lauth_zip`, ADD `lauth_country` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `lauth_city`, ADD `lauth_phonenumber` VARCHAR(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `lauth_country`");
  DB::statement("ALTER TABLE rvw_production_attachment_files ADD paf_designated_to VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER paf_document_size");

DB::statement("ALTER TABLE tbk_production_attachment_files ADD paf_designated_to VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER paf_document_size");
DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_usr_review_reopen` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `aflw_change_assign`");
DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_usr_review_reopen` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `aflw_change_assign`");
DB::statement("ALTER TABLE `tbk_article_flow` CHANGE `aflw_usr_review_reopen` `aflw_usr_review_reopen` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y - reviewer can be resubmit review'");

DB::statement("ALTER TABLE `rvw_article_flow` CHANGE `aflw_usr_review_reopen` `aflw_usr_review_reopen` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y - reviewer can be resubmit review'");
DB::statement("ALTER TABLE `rvw_issues` ADD `iss_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o' COMMENT 'o-open, c-close , r-reopen' AFTER `iss_special_issue`");
DB::statement("ALTER TABLE `tbk_issues` ADD `iss_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o' COMMENT 'o-open, c-close , r-reopen' AFTER `iss_special_issue`");

DB::statement("ALTER TABLE `rvw_issues` ADD `iss_status_date` DATETIME NULL AFTER `iss_status`");
DB::statement("ALTER TABLE `tbk_issues` ADD `iss_status_date` DATETIME NULL AFTER `iss_status`");
DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_add_article_to_issue` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to users to add articles to issue' AFTER `jset_manage_issue`");
DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_add_article_to_issue` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to users to add articles to issue' AFTER `jset_manage_issue`");
DB::statement("ALTER TABLE `rvw_advance_flow_movement` CHANGE `afm_button_title` `afm_button_title` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");
DB::statement("ALTER TABLE `tbk_advance_flow_movement` CHANGE `afm_button_title` `afm_button_title` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");
DB::statement("ALTER TABLE `rvw_email_tmpls` ADD `etmp_templete_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `etmp_name`");

DB::statement("ALTER TABLE `tbk_email_tmpls` ADD `etmp_templete_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `etmp_name`");
DB::statement("CREATE TABLE rvw_article_parallel_flow_movement (
    apfm_id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    apfm_aflw_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
    apfm_bgn_stg_jwf_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - parallel stage start id',
    apfm_travel_path_ids text COLLATE utf8_unicode_ci NOT NULL COMMENT 'comma separated journal flow ids',
    apfm_end_stg_jwf_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - parallel stage end id',
    apfm_status char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'a' COMMENT 'a-active,c-completed',
    apfm_posted_by bigint(20) UNSIGNED NOT NULL,
    apfm_posted_date datetime NOT NULL,
    apfm_proxy_id bigint(20) UNSIGNED DEFAULT NULL,
    apfm_operation char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
    PRIMARY KEY (apfm_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
     
DB::statement("CREATE TABLE tbk_article_parallel_flow_movement (
    apfm_id bigint(20) UNSIGNED,
    apfm_aflw_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
    apfm_bgn_stg_jwf_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - parallel stage start id',
    apfm_travel_path_ids text COLLATE utf8_unicode_ci NOT NULL COMMENT 'comma separated journal flow ids',
    apfm_end_stg_jwf_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_journal_workflows - parallel stage end id',
    apfm_status char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'a' COMMENT 'a-active,c-completed',
    apfm_posted_by bigint(20) UNSIGNED NOT NULL,
    apfm_posted_date datetime NOT NULL,
    apfm_proxy_id bigint(20) UNSIGNED DEFAULT NULL,
    apfm_operation char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
     `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
      PRIMARY KEY(`tbk_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
    DB::unprepared("DROP TRIGGER IF EXISTS
  `trg_article_parallel_flow_movement_after_insert`;
CREATE TRIGGER `trg_article_parallel_flow_movement_after_insert` AFTER
INSERT ON
  `rvw_article_parallel_flow_movement` FOR EACH ROW
INSERT
INTO
  tbk_article_parallel_flow_movement
SELECT
  *,
  NULL tbk_id
FROM
  rvw_article_parallel_flow_movement
WHERE
  apfm_id = NEW.apfm_id");
  
DB::unprepared("DROP TRIGGER IF EXISTS trg_article_parallel_flow_movement_after_update");
DB::unprepared("CREATE TRIGGER `trg_article_parallel_flow_movement_after_update` AFTER UPDATE ON `rvw_article_parallel_flow_movement` FOR EACH ROW BEGIN IF( NEW.apfm_operation != 'm' AND NEW.apfm_operation != 'e' ) THEN INSERT INTO tbk_article_parallel_flow_movement SELECT *, NULL tbk_id FROM rvw_article_parallel_flow_movement WHERE apfm_id = OLD.apfm_id ; END IF ; END");
DB::statement("CREATE TABLE rvw_article_stage_file_transfer_history (
    asfh_id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    asfh_art_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
    asfh_aflw_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
    asfh_ftp_id bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_ftp_locations',
    asfh_paf_ids text COLLATE utf8_unicode_ci NOT NULL COMMENT 'rvw_production_attachment_files ids',
    asfh_status char(1) COLLATE utf8_unicode_ci NOT NULL COMMENT 's-success,f-failed',
    asfh_posted_by bigint(20) UNSIGNED NOT NULL,
    asfh_posted_date datetime NOT NULL,
    asfh_proxy_id bigint(20) UNSIGNED DEFAULT NULL,
    asfh_operation char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
    PRIMARY KEY (asfh_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
    DB::statement("ALTER TABLE `rvw_article_authors` CHANGE `auth_title` `auth_title` VARCHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
    DB::statement("CREATE TABLE rvw_attachment_designated_roles(
        adr_id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        adr_paf_id BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_production_attachment_files',
        adr_atmnt_id BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_attachment_files',
        adr_role_id text COLLATE utf8_unicode_ci  COMMENT 'roles ids ',
        adr_submitted_type CHAR(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ps' COMMENT 'ps-productionsubmitted,as-authorsubmitted',
        adr_posted_by BIGINT(20) UNSIGNED NOT NULL,
        adr_posted_date DATETIME NOT NULL,
        adr_proxy_id BIGINT(20) UNSIGNED DEFAULT NULL,
        adr_operation CHAR(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
        PRIMARY KEY(adr_id)
      ) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci");
      
      
      DB::statement("CREATE TABLE tbk_attachment_designated_roles(
        adr_id BIGINT(20) UNSIGNED,
        adr_paf_id BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_production_attachment_files',
        adr_atmnt_id BIGINT(20) UNSIGNED NULL COMMENT 'pk of rvw_article_attachment_files',
        adr_role_id text COLLATE utf8_unicode_ci  COMMENT 'roles ids ',
        adr_submitted_type CHAR(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ps' COMMENT 'ps-productionsubmitted,as-authorsubmitted',
        adr_posted_by BIGINT(20) UNSIGNED NOT NULL,
        adr_posted_date DATETIME NOT NULL,
        adr_proxy_id BIGINT(20) UNSIGNED DEFAULT NULL,
        adr_operation CHAR(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
       `tbk_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT, 
        PRIMARY KEY(tbk_id)
      ) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci");
      DB::unprepared("DROP TRIGGER IF EXISTS
      `trg_attachment_designated_roles_after_insert`;
    CREATE TRIGGER `trg_attachment_designated_roles_after_insert` AFTER
    INSERT ON
      `rvw_attachment_designated_roles` FOR EACH ROW
    INSERT
    INTO
      tbk_attachment_designated_roles
    SELECT
      *,
      NULL tbk_id
    FROM
      rvw_attachment_designated_roles
    WHERE
      adr_id = NEW.adr_id");
      DB::unprepared("DROP TRIGGER IF EXISTS
      trg_attachment_designated_roles_after_update");
DB::unprepared("CREATE TRIGGER `trg_attachment_designated_roles_after_update` AFTER
UPDATE ON
  `rvw_attachment_designated_roles` FOR EACH ROW
BEGIN
    IF(
      NEW.adr_operation != 'm' AND NEW.adr_operation != 'e'
    ) THEN
  INSERT
INTO
  tbk_attachment_designated_roles
SELECT
  *,
  NULL tbk_id
FROM
  rvw_attachment_designated_roles
WHERE
  adr_id = OLD.adr_id ;
  END IF ;
END");
DB::statement("ALTER TABLE `rvw_ftp_locations` ADD `ftp_temp_id` BIGINT UNSIGNED NOT NULL COMMENT 'used in workflow import' AFTER `ftp_location`");

DB::statement("ALTER TABLE `tbk_ftp_locations` ADD `ftp_temp_id` BIGINT UNSIGNED NOT NULL COMMENT 'used in workflow import' AFTER `ftp_location`");

DB::statement("ALTER TABLE `rvw_ftp_locations` CHANGE `ftp_location` `ftp_location` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");

DB::statement("ALTER TABLE `tbk_ftp_locations` CHANGE `ftp_location` `ftp_location` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");
DB::statement("ALTER TABLE rvw_attachment_file_description ADD afdec_apply_stage_type CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r-review,p-production' AFTER afdec_default");

DB::statement("ALTER TABLE tbk_attachment_file_description ADD afdec_apply_stage_type CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r-review,p-production' AFTER afdec_default");

DB::statement("ALTER TABLE rvw_attachment_file_description ADD afdec_viewable_roles text COLLATE utf8_unicode_ci NULL COMMENT 'roles ids ' AFTER afdec_default");

DB::statement("ALTER TABLE tbk_attachment_file_description ADD afdec_viewable_roles text COLLATE utf8_unicode_ci NULL COMMENT 'roles ids ' AFTER afdec_default");

DB::statement("ALTER TABLE rvw_production_attachment_files ADD paf_description_id bigint(20) UNSIGNED NULL COMMENT 'pk of rvw_attachment_file_description' AFTER paf_designated_to");

DB::statement("ALTER TABLE tbk_production_attachment_files ADD paf_description_id bigint(20) UNSIGNED NULL COMMENT 'pk of rvw_attachment_file_description' AFTER paf_designated_to");
DB::statement("ALTER TABLE `rvw_ftp_locations` ADD `ftp_afdec_ids` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'comma separated pk of rvw_attachment_file_description' AFTER `ftp_jwf_id`");
DB::statement("ALTER TABLE `tbk_ftp_locations` ADD `ftp_afdec_ids` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'comma separated pk of rvw_attachment_file_description' AFTER `ftp_jwf_id`");

DB::statement("ALTER TABLE `rvw_login_tracking` ADD INDEX(`ltk_action_type`)");
DB::statement("ALTER TABLE rvw_articles ADD art_prduction_submission_accepted_date DATE NULL DEFAULT NULL COMMENT 'for submit production article updated accepted date ' AFTER art_resubmission_after_reject");
DB::statement("ALTER TABLE tbk_articles ADD art_prduction_submission_accepted_date DATE NULL DEFAULT NULL COMMENT 'for submit production article updated accepted date' AFTER art_resubmission_after_reject");
DB::statement("ALTER TABLE rvw_articles ADD art_prduction_submission_revised_date DATE NULL DEFAULT NULL COMMENT 'for submit production article updated revised date ' AFTER art_resubmission_after_reject");
DB::statement("ALTER TABLE tbk_articles ADD art_prduction_submission_revised_date DATE NULL DEFAULT NULL COMMENT 'for submit production article updated revised date' AFTER art_resubmission_after_reject");

DB::statement("ALTER TABLE `rvw_attachment_file_description` ADD `afdec_attach_to_author` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-yes, n-no' AFTER `afdec_default`");
DB::statement("ALTER TABLE `tbk_attachment_file_description` ADD `afdec_attach_to_author` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-yes, n-no' AFTER `afdec_default`");

DB::statement("ALTER TABLE `rvw_email_attachments` ADD `emat_is_production_files` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-prodution files, - not production files' AFTER `emat_file_name`");
DB::statement("ALTER TABLE `tbk_email_attachments` ADD `emat_is_production_files` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-prodution files, - not production files' AFTER `emat_file_name`");


DB::statement("ALTER TABLE `rvw_attachment_designated_roles` ADD INDEX(`adr_paf_id`)");
DB::statement("DELETE FROM `rvw_attachment_designated_roles` WHERE `adr_paf_id` NOT IN(SELECT paf_id FROM rvw_production_attachment_files)");
DB::statement("ALTER TABLE `rvw_attachment_designated_roles` ADD FOREIGN KEY (`adr_paf_id`) REFERENCES `rvw_production_attachment_files`(`paf_id`) ON DELETE CASCADE ON UPDATE CASCADE");

DB::statement("ALTER TABLE `rvw_attachment_designated_roles` ADD INDEX(`adr_atmnt_id`)");
DB::statement("DELETE FROM `rvw_attachment_designated_roles` WHERE `adr_atmnt_id` NOT IN (SELECT atmnt_id FROM rvw_article_attachment_files)");
DB::statement("ALTER TABLE `rvw_attachment_designated_roles` ADD FOREIGN KEY (`adr_atmnt_id`) REFERENCES `rvw_article_attachment_files`(`atmnt_id`) ON DELETE CASCADE ON UPDATE CASCADE");
DB::statement("ALTER TABLE `rvw_journal_workflows` ADD `jwf_afdec_ids` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'pk of rvw_attachment_file_description' AFTER `jwf_production_upload`");
DB::statement("ALTER TABLE `tbk_journal_workflows` ADD `jwf_afdec_ids` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'pk of rvw_attachment_file_description' AFTER `jwf_production_upload`");
DB::statement("ALTER TABLE `rvw_article_types` ADD `artp_article_submission_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=can submit articles,n=cannot submit articles' AFTER `artp_palette_color_code`");

DB::statement("ALTER TABLE `tbk_article_types` ADD `artp_article_submission_status` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y=can submit articles,n=cannot submit articles' AFTER `artp_palette_color_code`");
DB::statement("ALTER TABLE `rvw_roles` ADD `role_used_in` CHAR(4) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r - review, p-production' AFTER `role_assigned_role`");
DB::statement("ALTER TABLE `tbk_roles` ADD `role_used_in` CHAR(4) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r - review, p-production' AFTER `role_assigned_role`");

DB::statement("UPDATE `rvw_roles` SET `role_used_in`= 'r,p' WHERE role_assigned_role IN ('author','journal_admin')");
DB::statement("ALTER TABLE `rvw_email_attachments` ADD `emat_art_id` BIGINT(20) NULL DEFAULT NULL AFTER `emat_ade_id`");
DB::statement("ALTER TABLE `tbk_email_attachments` ADD `emat_art_id` BIGINT(20) NULL DEFAULT NULL AFTER `emat_ade_id`");
DB::statement("ALTER TABLE `rvw_articles` ADD `art_epub_date` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'date format = YYYY-mm-dd' AFTER `art_decision_date`, ADD `art_ppub_date` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'date format = YYYY-mm-dd' AFTER `art_epub_date`");

DB::statement("ALTER TABLE `tbk_articles` ADD `art_epub_date` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'date format = YYYY-mm-dd' AFTER `art_decision_date`, ADD `art_ppub_date` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'date format = YYYY-mm-dd' AFTER `art_epub_date`");

DB::statement("ALTER TABLE `rvw_articles` CHANGE `art_stage_submission_method` `art_stage_submission_method` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'o' COMMENT 'artice stage submission method Normal n, zip by stage submission z ,Default o,p = AoP2 import'");
DB::statement("ALTER TABLE `rvw_required_file_types` ADD `rft_sort_order` BIGINT(20) NOT NULL DEFAULT '0' AFTER `rft_req_fld`");
DB::statement("ALTER TABLE `tbk_required_file_types` ADD `rft_sort_order` BIGINT(20) NOT NULL DEFAULT '0' AFTER `rft_req_fld`");
DB::statement("DELETE FROM `rvw_advance_flow_movement` WHERE `afm_id` NOT IN (SELECT * FROM (SELECT afm_id FROM rvw_advance_flow_movement JOIN rvw_journal_workflows ON afm_fwm_id = jwf_fwm_id AND  afm_jwf_id = jwf_id) as sel_tb)");
DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_view_file_inventory` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view inventory files' AFTER `jset_edit_reviewer_count`");

DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_view_file_inventory` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view inventory files' AFTER `jset_edit_reviewer_count`");

DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_view_file_inventory` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permitted roles to view file inventory' AFTER `atotp_edit_reviewer_count`");

DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_view_file_inventory` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permitted roles to view file inventory' AFTER `atotp_edit_reviewer_count`");
DB::statement("UPDATE `rvw_user_home_filter_sort_keys` SET uhfs_home_filter_keys = REPLACE(uhfs_home_filter_keys,'art_id','art_code')");
DB::statement("UPDATE `rvw_user_journal_dashboard_tile_sort_keys` SET ujdtsk_sort_keys = REPLACE(ujdtsk_sort_keys,'art_id','art_code')");
DB::statement("UPDATE `rvw_user_journal_sort_keys` SET ujsk_sort_keys = REPLACE(ujsk_sort_keys,'art_id','art_code')");
DB::statement("UPDATE rvw_user_home_filter_sort_keys SET uhfs_home_filter_keys = REPLACE(uhfs_home_filter_keys,'art_artp_id','artp_article_type')");
DB::statement("UPDATE rvw_user_journal_dashboard_tile_sort_keys SET ujdtsk_sort_keys = REPLACE(ujdtsk_sort_keys,'art_artp_id','artp_article_type')");
DB::statement("UPDATE rvw_user_journal_sort_keys SET ujsk_sort_keys = REPLACE(ujsk_sort_keys,'art_artp_id','artp_article_type')");
DB::statement("UPDATE rvw_user_home_filter_sort_keys SET uhfs_home_filter_keys = REPLACE(uhfs_home_filter_keys,'art_submission_date_format','art_submission_date')");
DB::statement("UPDATE rvw_user_journal_dashboard_tile_sort_keys SET ujdtsk_sort_keys = REPLACE(ujdtsk_sort_keys,'art_submission_date_format','art_submission_date')");
DB::statement("UPDATE rvw_user_journal_sort_keys SET ujsk_sort_keys = REPLACE(ujsk_sort_keys,'art_submission_date_format','art_submission_date')");
DB::statement("UPDATE rvw_user_home_filter_sort_keys SET uhfs_home_filter_keys = REPLACE(uhfs_home_filter_keys,'art_update_last_date_format','art_update_last_date')");
DB::statement("UPDATE rvw_user_journal_dashboard_tile_sort_keys SET ujdtsk_sort_keys = REPLACE(ujdtsk_sort_keys,'art_update_last_date_format','art_update_last_date')");
DB::statement("UPDATE rvw_user_journal_sort_keys SET ujsk_sort_keys = REPLACE(ujsk_sort_keys,'art_update_last_date_format','art_update_last_date')");
DB::statement("ALTER TABLE `rvw_article_flow` CHANGE `aflw_skip_assignment` `aflw_skip_assignment` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");

DB::statement("ALTER TABLE `tbk_article_flow` CHANGE `aflw_skip_assignment` `aflw_skip_assignment` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
DB::statement("ALTER TABLE `rvw_ftp_locations` ADD `ftp_import_stage_name` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'stage name refer in import xml' AFTER `ftp_location`, ADD `ftp_action_for` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'e' COMMENT 'e = export, i = import, b= both export and import' AFTER `ftp_import_stage_name`");

DB::statement("ALTER TABLE `tbk_ftp_locations` ADD `ftp_import_stage_name` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'stage name refer in import xml' AFTER `ftp_location`, ADD `ftp_action_for` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'e' COMMENT 'e = export, i = import, b= both export and import' AFTER `ftp_import_stage_name`");

DB::statement("ALTER TABLE `rvw_ftp_locations` ADD `ftp_metadata_on_export` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y = send metadata on export, n= no' AFTER `ftp_action_for`");

DB::statement("ALTER TABLE `tbk_ftp_locations` ADD `ftp_metadata_on_export` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y = send metadata on export, n= no' AFTER `ftp_action_for`");

DB::statement("CREATE TABLE `rvw_stage_import_go_files` (
  `sig_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sig_file_name` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `sig_aflw_id` bigint(20) UNSIGNED DEFAULT NULL,
  `sig_status` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 's-success import,f-failed import,r-repeat import',	
  `sig_message` text COLLATE utf8_unicode_ci NULL COMMENT 'json data',
  `sig_posted_by` bigint(20) UNSIGNED NOT NULL,
  `sig_posted_date` datetime NOT NULL,
  `sig_proxy_id` bigint(20) UNSIGNED NOT NULL,
  `sig_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
 PRIMARY KEY (`sig_id`),
 UNIQUE(`sig_file_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");

DB::statement("CREATE TABLE `tbk_stage_import_go_files` (
  `sig_id` bigint(20) UNSIGNED NOT NULL,
  `sig_file_name` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `sig_aflw_id` bigint(20) UNSIGNED DEFAULT NULL,
  `sig_status` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 's-success import,f-failed import,r-repeat import',	
  `sig_message` text COLLATE utf8_unicode_ci NULL COMMENT 'json data',
  `sig_posted_by` bigint(20) UNSIGNED NOT NULL,
  `sig_posted_date` datetime NOT NULL,
  `sig_proxy_id` bigint(20) UNSIGNED NOT NULL,
  `sig_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
  `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
 PRIMARY KEY (`tbk_id`),
 index(sig_aflw_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");

DB::unprepared("drop trigger if exists trg_stage_import_go_files_after_insert; CREATE TRIGGER trg_stage_import_go_files_after_insert  AFTER INSERT ON rvw_stage_import_go_files FOR EACH ROW INSERT INTO tbk_stage_import_go_files SELECT *,NULL tbk_id FROM rvw_stage_import_go_files WHERE sig_id= NEW.sig_id");

DB::unprepared("drop trigger if exists trg_stage_import_go_files_after_update; CREATE TRIGGER trg_stage_import_go_files_after_update  AFTER UPDATE ON rvw_stage_import_go_files FOR EACH ROW INSERT INTO tbk_stage_import_go_files SELECT *,NULL tbk_id FROM rvw_stage_import_go_files WHERE sig_id= OLD.sig_id");
DB::insert("INSERT INTO `rvw_email_tmpls` (`etmp_name`, `etmp_templete_name`, `etmp_notification`, `etmp_cust_to`, `etmp_cc`, `etmp_cust_cc`, `etmp_bcc`, `etmp_cust_bcc`, `etmp_content_type`, `etmp_subject`, `etmp_email_template`, `etmp_posted_date`, `etmp_posted_by`, `etmp_proxy_id`, `etmp_operation`)
VALUES('stage_import_email', '', 'Journals production', '', '\"\"', '', '\"\"', '', '', 'Stage import error report',
'<p>Dear ##RECIPIENT_FULLNAME##,</p>\n<p> </p>\n<p>Journal title : ##JOURNAL_NAME##</p>\n<p>Article type : ##ARTICLE_TYPE##</p>\n<p>Article title : ##ARTICLE_TITLE##</p>\n<p>Article ID : ##ARTICLE_ID##</p>\n<p>Stage :  ##ARTICLE_STAGE_NAME##</p>\n<p> </p>\n<p>Below mentioned errors occur while <strong>stage import</strong> :</p>\n<p>##STAGE_IMPORT_ERRORS##</p>\n<p> </p>\n<p>Regards,</p>\n<p>ReView Team</p>\n<p> </p>\n<p> </p>',
now(), 339, 0, 'u')");
DB::statement("ALTER TABLE `rvw_attachment_file_description` CHANGE `afdec_file_type_id` `afdec_file_type_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
DB::statement("ALTER TABLE `tbk_attachment_file_description` CHANGE `afdec_file_type_id` `afdec_file_type_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_view_article_pdf` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view article pdf' AFTER `jset_edit_reviewer_count`");
DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_view_article_pdf` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view article pdf' AFTER `jset_edit_reviewer_count`");
DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_view_article_pdf` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view article pdf' AFTER `atotp_edit_reviewer_count`");
DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_view_article_pdf` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'permission to view article pdf' AFTER `atotp_edit_reviewer_count`");
DB::statement("ALTER TABLE `rvw_modules` ADD `mdl_journal` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' AFTER `mdl_clnt_id`");

DB::statement("ALTER TABLE `rvw_modules` ADD `mdl_book` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_journal`");

DB::statement("ALTER TABLE `rvw_modules` ADD `mdl_conference` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_book`");


DB::statement("ALTER TABLE `tbk_modules` ADD `mdl_journal` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' AFTER `mdl_clnt_id`");

DB::statement("ALTER TABLE `tbk_modules` ADD `mdl_book` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_journal`");

DB::statement("ALTER TABLE `tbk_modules` ADD `mdl_conference` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_book`");

DB::statement("ALTER TABLE `rvw_journals` ADD `jnl_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `jnl_id`");

DB::statement("ALTER TABLE `tbk_journals` ADD `jnl_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `jnl_id`");
DB::insert("INSERT INTO rvw_general_permissions (permission_route, permission_parent_route, permission_caption, permission_icon, permission_roles, permission_posted_by, permission_posted_date, permission_proxy_id, permission_operation) VALUES ('books', 'books', 'Books', 'book', '[\"\",\"super_admin\"]', '339', '2021-08-18 09:45:54', '0', 'u')");
DB::statement("ALTER TABLE `rvw_roles` CHANGE `role_used_in` `role_used_in` CHAR(8) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r - review, p-production, b-book'");

DB::statement("ALTER TABLE `tbk_roles` CHANGE `role_used_in` `role_used_in` CHAR(8) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r - review, p-production, b-book'");
DB::statement("ALTER TABLE rvw_journal_settings ADD jset_manage_article_type TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to mange article type' AFTER jset_manage_issue");
DB::statement("ALTER TABLE tbk_journal_settings ADD jset_manage_article_type TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to mange article type' AFTER jset_manage_issue");
DB::statement("ALTER TABLE rvw_article_type_advance_options ADD atotp_lead_contributer_agreement CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-yes,n-no' AFTER atotp_co_authors_agreement");
DB::statement("ALTER TABLE tbk_article_type_advance_options ADD atotp_lead_contributer_agreement CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y-yes,n-no' AFTER atotp_co_authors_agreement");
DB::statement("ALTER TABLE `rvw_article_types` ADD `artp_book_subtitle` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'subtitle of book' AFTER `artp_article_type`");

DB::statement("ALTER TABLE `tbk_article_types` ADD `artp_book_subtitle` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'subtitle of book' AFTER `artp_article_type`");
DB::statement("ALTER TABLE `rvw_articles` ADD `art_chapter_order` INT(11) UNSIGNED NOT NULL COMMENT 'sort order for chapter submittion' AFTER `art_title`");
DB::statement("ALTER TABLE `tbk_articles` ADD `art_chapter_order` INT(11) UNSIGNED NOT NULL COMMENT 'sort order for chapter submittion' AFTER `art_title`");
DB::statement("ALTER TABLE `rvw_review_reject_reasons` CHANGE `rjct_reason_reviewers` `rjct_reason_reviewers` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y' COMMENT 'y-reviewer reject reason, c-contributor reject reason, n-other reject reason'");
DB::insert("INSERT INTO `rvw_email_tmpls` (`etmp_id`, `etmp_name`, `etmp_templete_name`, `etmp_notification`, `etmp_cust_to`, `etmp_cc`, `etmp_cust_cc`, `etmp_bcc`, `etmp_cust_bcc`, `etmp_content_type`, `etmp_subject`, `etmp_email_template`, `etmp_posted_date`, `etmp_posted_by`, `etmp_proxy_id`, `etmp_operation`) VALUES (NULL, 'contributor_on_fly', '', 'User', '', '\"\"', '', '\"\"', '', '', 'You have been added as a contributor - Please authorize your account', 
'<p>Dear ##RECIPIENT_TITLE## ##RECIPIENT_FULLNAME##,</p><p>You have been shortlisted as a contributor for a chapter</p><p>##ARTICLE_TITLE##</p><p>Please use the following link to activate your account:</p><p>##CONFIRMATION_URL##</p><p> </p><p>Kind regards,</<p>Editorial Office</p><p>##JOURNAL_NAME##</p>', '2021-09-17 00:00:00', 1, 0, 'i');");
DB::statement("ALTER TABLE `rvw_stage_email_tmpls` ADD `stage_etmp_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `stage_etmp_id`");
DB::statement("ALTER TABLE `tbk_stage_email_tmpls` ADD `stage_etmp_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `stage_etmp_id`;");
// DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_chapter_next_stages` TEXT NULL DEFAULT NULL COMMENT 'For book workflow, after successfully validating current stage jwf_id of child stages are added in this column. Which is used in the master chapter-view page to submit multiple chapters to next stage' AFTER `aflw_usr_review_reopen`");
// DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_chapter_next_stages` TEXT NULL DEFAULT NULL COMMENT 'For book workflow, after successfully validating current stage jwf_id of child stages are added in this column. Which is used in the master chapter-view page to submit multiple chapters to next stage' AFTER `aflw_usr_review_reopen`");
DB::statement("ALTER TABLE `rvw_generic_forms` ADD `gncf_form_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `gncf_jnl_id`");
DB::statement("ALTER TABLE `tbk_generic_forms` ADD `gncf_form_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `gncf_jnl_id`");
DB::statement("ALTER TABLE rvw_flags ADD flag_platform CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER flag_id");

DB::statement("ALTER TABLE tbk_flags ADD flag_platform CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER flag_id");
DB::insert("INSERT INTO `rvw_general_permissions` (`id`, `permission_route`, `permission_parent_route`, `permission_caption`, `permission_icon`, `permission_roles`, `permission_posted_by`, `permission_posted_date`, `permission_proxy_id`, `permission_operation`) VALUES (NULL, 'switch-platform', 'switch-platform', 'Switch platform', 'cog', '[\"\",\"super_admin\",\"admin\"]', '339', '2021-10-07 09:45:54', '0', 'i')");
DB::statement("ALTER TABLE `rvw_email_tmpls` ADD `etmp_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'g' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\',g=\'general\'' AFTER `etmp_id`");
DB::statement("ALTER TABLE `tbk_email_tmpls` ADD `etmp_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'g' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\',g=\'general\'' AFTER `etmp_id`");
DB::statement("ALTER TABLE `rvw_generic_form_elements` ADD `emt_populate_data` TINYINT(1) NULL COMMENT '1= yes, 0=no' AFTER `emt_help_icon_text`, ADD `emt_source_formid` BIGINT(20) NULL AFTER `emt_populate_data`, ADD `emt_source_elementid` BIGINT(20) NULL COMMENT 'element id from the form' AFTER `emt_source_formid`");


DB::statement("ALTER TABLE `tbk_generic_form_elements` ADD `emt_populate_data` TINYINT(1) NULL COMMENT '1= yes, 0=no' AFTER `emt_help_icon_text`, ADD `emt_source_formid` BIGINT(20) NULL AFTER `emt_populate_data`, ADD `emt_source_elementid` BIGINT(20) NULL COMMENT 'element id from the form' AFTER `emt_source_formid`");
DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0' AFTER `aflw_flow_operation`");
DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0' AFTER `aflw_flow_operation`");
DB::statement("ALTER TABLE `rvw_attachment_file_description` CHANGE `afdec_apply_stage_type` `afdec_apply_stage_type` CHAR(8) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r-review,p-production'");
DB::statement("ALTER TABLE `tbk_attachment_file_description` CHANGE `afdec_apply_stage_type` `afdec_apply_stage_type` CHAR(8) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r' COMMENT 'r-review,p-production'");
DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_separate_adhoc_keywords` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'values y = yes,n=no, if yes then separate general keywords from adhoc keywords in article submission' AFTER `atotp_user_input_keyword`");

DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_separate_adhoc_keywords` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'values y = yes,n=no, if yes then separate general keywords from adhoc keywords in article submission' AFTER `atotp_user_input_keyword`");
DB::statement("ALTER TABLE `rvw_article_notification_emails` CHANGE `ane_stage_etmp_id` `ane_stage_etmp_id` BIGINT(20) NULL DEFAULT NULL");

DB::statement("ALTER TABLE `rvw_article_notification_emails` ADD `ane_event_etmp_id` BIGINT(20) NULL DEFAULT NULL AFTER `ane_stage_etmp_id`");


DB::statement("ALTER TABLE `tbk_article_notification_emails` CHANGE `ane_stage_etmp_id` `ane_stage_etmp_id` BIGINT(20) NULL DEFAULT NULL");

DB::statement("ALTER TABLE `tbk_article_notification_emails` ADD `ane_event_etmp_id` BIGINT(20) NULL DEFAULT NULL AFTER `ane_stage_etmp_id`");
DB::statement("ALTER TABLE rvw_journal_settings ADD jset_separate_adhoc_keywords CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'values y = yes,n=no, if yes then separate general keywords from adhoc keywords in article submission' AFTER jset_user_input_keyword");

DB::statement("ALTER TABLE tbk_journal_settings ADD jset_separate_adhoc_keywords CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'values y = yes,n=no, if yes then separate general keywords from adhoc keywords in article submission' AFTER jset_user_input_keyword");
DB::statement("ALTER TABLE `rvw_copyright_master` ADD `crtm_license_platform` CHAR(1) NOT NULL COMMENT 'j - journal, b - book, c - conference' AFTER `crtm_id`");
DB::statement("ALTER TABLE `tbk_copyright_master` ADD `crtm_license_platform` CHAR(1) NOT NULL COMMENT 'j - journal, b - book, c - conference' AFTER `crtm_id`");

DB::statement("ALTER TABLE `rvw_copyright_master` ADD `crtm_license_display_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `crtm_license_name`");
DB::statement("ALTER TABLE `tbk_copyright_master` ADD `crtm_license_display_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `crtm_license_name`");

DB::statement("ALTER TABLE `rvw_copyright_master` ADD `crtm_license_custom` CHAR(1) NOT NULL DEFAULT 'n' AFTER `crtm_license_content`");
DB::statement("ALTER TABLE `tbk_copyright_master` ADD `crtm_license_custom` CHAR(1) NOT NULL DEFAULT 'n' AFTER `crtm_license_content`");
DB::statement("ALTER TABLE `rvw_article_type_advance_options` CHANGE `atotp_lead_contributer_agreement` `atotp_lead_contributer_agreement` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'y-yes,n-no'");



DB::statement("ALTER TABLE `tbk_article_type_advance_options` CHANGE `atotp_lead_contributer_agreement` `atotp_lead_contributer_agreement` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'y-yes,n-no'");
DB::statement("ALTER TABLE `rvw_journal_metadata` CHANGE `jm_meta_value` `jm_meta_value` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
DB::statement("ALTER TABLE `tbk_journal_metadata` CHANGE `jm_meta_value` `jm_meta_value` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
DB::statement("ALTER TABLE rvw_copyright_master CHANGE crtm_license_display_name crtm_license_display_name VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");

DB::statement("ALTER TABLE tbk_copyright_master CHANGE crtm_license_display_name crtm_license_display_name VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL");
DB::statement("ALTER TABLE `rvw_article_types` ADD `artp_delivery_date` DATETIME NULL DEFAULT NULL COMMENT 'New chapters cannot add to a book if the delivery date is exceeded.' AFTER `artp_start_date`");
DB::statement("ALTER TABLE `tbk_article_types` ADD `artp_delivery_date` DATETIME NULL DEFAULT NULL COMMENT 'New chapters cannot add to a book if the delivery date is exceeded.' AFTER `artp_start_date`");
DB::statement("ALTER TABLE `rvw_articles` ADD `art_email_template` BIGINT NULL AFTER `art_stage_submission_method`");

DB::statement("ALTER TABLE `tbk_articles` ADD `art_email_template` BIGINT NULL AFTER `art_stage_submission_method`");

DB::statement("ALTER TABLE `rvw_articles` ADD `art_publication_volume` BIGINT NULL AFTER `art_email_template`, ADD `art_publication_issue` BIGINT NULL AFTER `art_publication_volume`, ADD `art_auth_response_due` BIGINT NULL AFTER `art_publication_issue`");

DB::statement("ALTER TABLE `tbk_articles` ADD `art_publication_volume` BIGINT NULL AFTER `art_email_template`, ADD `art_publication_issue` BIGINT NULL AFTER `art_publication_volume`, ADD `art_auth_response_due` BIGINT NULL AFTER `art_publication_issue`");
DB::statement("ALTER TABLE `rvw_articles` ADD `art_invitation_due`  DATE NULL DEFAULT NULL AFTER `art_publication_issue`");
DB::statement("ALTER TABLE `tbk_articles` ADD `art_invitation_due`  DATE NULL DEFAULT NULL AFTER `art_publication_issue`");
DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_draft_proposal_invite` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `jset_author_confirmation_jnl`");
DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_draft_proposal_invite` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `jset_author_confirmation_jnl`");
DB::statement("ALTER TABLE
  `rvw_ftp_locations` ADD `ftp_enable_private_key` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `ftp_password`,
  ADD `ftp_private_key_path` VARCHAR(85) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `ftp_enable_private_key`");
DB::statement("ALTER TABLE
  `tbk_ftp_locations` ADD `ftp_enable_private_key` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `ftp_password`,
  ADD `ftp_private_key_path` VARCHAR(85) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL AFTER `ftp_enable_private_key`");
  DB::statement("CREATE TABLE `rvw_generic_discussion` (
    `gdis_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `gdis_art_id` bigint(20) unsigned NOT NULL,
    `gdis_title` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    `gdis_status` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    `gdis_participants_by_role_id` json NOT NULL,
    `gdis_participants_by_usr_id` json NOT NULL,
    `gdis_started_by` bigint(20) unsigned DEFAULT NULL,
    `gdis_posted_by` bigint(20) unsigned NOT NULL,
    `gdis_proxy_id` bigint(20) NOT NULL,
    `gdis_posted_date` datetime NOT NULL,
    `gdis_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY (`gdis_id`)
   ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
   
   
   
   
   DB::statement("CREATE TABLE `rvw_generic_discussion_cmts` (
    `gdsc_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `gdsc_gdis_id` bigint(20) unsigned NOT NULL COMMENT 'pk of rvw_generic_discussion',
    `gdsc_comment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    `gdsc_posted_by` bigint(20) unsigned NOT NULL,
    `gdsc_proxy_id` bigint(20) NOT NULL,
    `gdsc_posted_date` datetime NOT NULL,
    `gdsc_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY (`gdsc_id`)
   ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
   
   
   
   
   
   DB::statement("CREATE TABLE `rvw_generic_discussion_read_status` (
    `gdrs_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `gdrs_gdsc_id` bigint(20) unsigned NOT NULL COMMENT 'pk of rvw_generic_discussion_cmts',
    `gdrs_posted_by` bigint(20) unsigned NOT NULL,
    `gdrs_proxy_id` bigint(20) NOT NULL,
    `gdrs_posted_date` datetime NOT NULL,
    `gdrs_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY (`gdrs_id`)
   ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
   
   
   
   DB::statement("ALTER TABLE `rvw_modules` ADD `mdl_generic_discussion` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_casrai_credit`");
   DB::statement("ALTER TABLE `tbk_modules` ADD `mdl_generic_discussion` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `mdl_casrai_credit`");
   
   
   
   DB::statement("ALTER TABLE rvw_article_type_advance_options ADD atotp_generic_discussion TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to start discussion' AFTER atotp_rescind_article");
   DB::statement("ALTER TABLE tbk_article_type_advance_options ADD atotp_generic_discussion TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to start discussion' AFTER atotp_rescind_article");
   DB::statement("UPDATE rvw_copyright_master SET crtm_license_platform = 'j' WHERE rvw_copyright_master.crtm_license_platform = ''");

/*   DB::statement("CREATE TABLE `tbk_generic_discussion` (`gdis_id` bigint(20) unsigned NOT NULL , `gdis_art_id` bigint(20) unsigned NOT NULL, `gdis_title` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdis_status` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdis_participants_by_role_id` json NOT NULL, `gdis_participants_by_usr_id` json NOT NULL, `gdis_started_by` bigint(20) unsigned DEFAULT NULL, `gdis_posted_by` bigint(20) unsigned NOT NULL, `gdis_proxy_id` bigint(20) NOT NULL, `gdis_posted_date` datetime NOT NULL, `gdis_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");

   DB::statement("CREATE TABLE `tbk_generic_discussion_cmts` (`gdsc_id` bigint(20) unsigned NOT NULL , `gdsc_gdis_id` bigint(20) unsigned NOT NULL COMMENT 'pk of tbk_generic_discussion', `gdsc_comment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdsc_posted_by` bigint(20) unsigned NOT NULL, `gdsc_proxy_id` bigint(20) NOT NULL, `gdsc_posted_date` datetime NOT NULL, `gdsc_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");

   DB::statement("CREATE TABLE `tbk_generic_discussion_read_status` ( `gdrs_id` bigint(20) unsigned NOT NULL, `gdrs_gdsc_id` bigint(20) unsigned NOT NULL COMMENT 'pk of tbk_generic_discussion_cmts', `gdrs_posted_by` bigint(20) unsigned NOT NULL, `gdrs_proxy_id` bigint(20) NOT NULL, `gdrs_posted_date` datetime NOT NULL, `gdrs_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");


DB::unprepared("CREATE TRIGGER trg_generic_discussion_after_insert  AFTER INSERT ON rvw_generic_discussion FOR EACH ROW INSERT INTO tbk_generic_discussion SELECT *,NULL tbk_id FROM rvw_generic_discussion WHERE gdis_id= NEW.gdis_id");

DB::unprepared("CREATE TRIGGER trg_generic_discussion_after_update  AFTER UPDATE ON rvw_generic_discussion FOR EACH ROW INSERT INTO tbk_generic_discussion SELECT *,NULL tbk_id FROM rvw_generic_discussion WHERE gdis_id= OLD.gdis_id");

DB::unprepared("CREATE TRIGGER trg_generic_discussion_cmts_after_insert  AFTER INSERT ON rvw_generic_discussion_cmts FOR EACH ROW INSERT INTO tbk_generic_discussion_cmts SELECT *,NULL tbk_id FROM rvw_generic_discussion_cmts WHERE gdsc_id= NEW.gdsc_id");

DB::unprepared("CREATE TRIGGER trg_generic_discussion_cmts_after_update  AFTER UPDATE ON rvw_generic_discussion_cmts FOR EACH ROW INSERT INTO tbk_generic_discussion_cmts SELECT *,NULL tbk_id FROM rvw_generic_discussion_cmts WHERE gdsc_id= OLD.gdsc_id");

DB::unprepared("CREATE TRIGGER trg_generic_discussion_read_status_after_insert  AFTER INSERT ON rvw_generic_discussion_read_status FOR EACH ROW INSERT INTO tbk_generic_discussion_read_status SELECT *,NULL tbk_id FROM rvw_generic_discussion_read_status WHERE gdrs_id= NEW.gdrs_id");


DB::unprepared("CREATE TRIGGER trg_generic_discussion_read_status_after_update  AFTER UPDATE ON rvw_generic_discussion_read_status FOR EACH ROW INSERT INTO tbk_generic_discussion_read_status SELECT *,NULL tbk_id FROM rvw_generic_discussion_read_status WHERE gdrs_id= OLD.gdrs_id");
*/

            }
            
   }catch (\Exception $e) {
    throw new \Exception($e->getTraceAsString());
    
       }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
