<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RvwJournalPermission extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('rvw_journal_permission', function (Blueprint $table) {
            $table->bigIncrements('jp_id');
            $table->bigInteger('jp_jpm_id');
            $table->jsonb('jp_add_notes')->nullable();
            $table->jsonb('jp_flag_articles')->nullable();
            $table->jsonb('jp_edit_articles')->nullable();
            $table->jsonb('jp_transfer_article')->nullable();
            $table->jsonb('jp_rescind_article')->nullable();
            $table->jsonb('jp_reset_article')->nullable();
            $table->jsonb('jp_view_auditrail')->nullable();
            $table->jsonb('jp_view_email_log')->nullable();
            $table->jsonb('jp_stage_manual_reminder')->nullable();
            $table->jsonb('jp_edit_reviewer_count')->nullable();
            $table->jsonb('jp_view_file_inventory')->nullable();
            $table->jsonb('jp_view_article_pdf')->nullable();
            $table->jsonb('jp_auto_assign_role')->nullable();
            $table->jsonb('jp_change_usr_assigmnts')->nullable();
            $table->jsonb('jp_move_article_from_payment')->nullable();
            $table->jsonb('jp_reinstantiate_payment')->nullable();
            $table->jsonb('jp_rate_reviewer')->nullable();
            $table->bigInteger('jp_posted_by')->nullable();
            $table->dateTime('jp_posted_date');
            $table->bigInteger('jp_proxy_id');
            $table->char('jp_operation',1);  
        });
        DB::unprepared('
        CREATE TRIGGER trg_journal_permission_after_insert AFTER INSERT ON `rvw_journal_permission` FOR EACH ROW
        BEGIN
        INSERT INTO tbk_journal_permission SELECT *,NULL tbk_id FROM rvw_journal_permission WHERE jp_id= NEW.jp_id;
        END
        ');
        DB::unprepared("
        CREATE TRIGGER trg_journal_permission_after_update AFTER UPDATE ON `rvw_journal_permission` FOR EACH ROW
        BEGIN
        IF (NEW.jp_operation != 'm') THEN INSERT INTO tbk_journal_permission SELECT *,NULL tbk_id FROM rvw_journal_permission WHERE jp_id= OLD.jp_id;
        END IF;
        END
        ");
        
            
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_journal_permission');
    }
}
