<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RvwEmailDeeplinkClickTracking extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
     
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_email_deeplink_click_tracking` (
            `edt_id` bigint(20) UNSIGNED NOT NULL,
            `edt_ip` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
            `edt_browser` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
            `edt_os` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
            `edt_deeplink_token` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
            `edt_action_type` char(3) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ec-email confirmation,url-user url email confirmation,ra-review accpet,rr-review reject,ap-article proposal',
            `edt_posted_by` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_user',
            `edt_posted_date` datetime NOT NULL,
            `edt_proxy_id` bigint(20) NOT NULL,
            `edt_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
          ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_email_deeplink_click_tracking');
    }
}
