<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TbkUserJournalDashboardFilterKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbk_user_journal_dashboard_filter_keys', function (Blueprint $table) {
            $table->bigIncrements('tbk_id');
            $table->bigInteger('ujdtfk_usr_id');
            $table->bigInteger('ujdtfk_id');
            $table->bigInteger('ujdtfk_jnl_id');
            $table->bigInteger('ujdtfk_role_id')->nullable();
            $table->text('ujdtfk_filter_keys')->collation('utf8_unicode_ci');
            $table->bigInteger('ujdtfk_posted_by');
            $table->dateTime('ujdtfk_posted_date');
            $table->bigInteger('ujdtfk_proxy_id');
            $table->char('ujdtfk_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('tbk_user_journal_dashboard_filter_keys');
    }
}
