<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try {
            if (Schema::hasColumn('rvw_article_gnf_form_data_temp', 'gdata_user_roles')) {
            }else{
                DB::statement("ALTER TABLE rvw_article_gnf_form_data_temp ADD `gdata_user_roles` text COLLATE utf8_unicode_ci COMMENT 'user role (comma separate)' AFTER gdata_element_type");
            }
        } catch (\Exception $e) {
            DB::rollback();
        }
         
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('rvw_article_gnf_form_data_temp', function (Blueprint $table) {
            Schema::dropColumn('gdata_user_roles');
        });
    }
};
