<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try
        {
            DB::statement("CREATE TABLE IF NOT EXISTS `rvw_article_next_task` (
                `ant_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `ant_usr_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_users',
                `ant_jnl_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_journals',
                `ant_role_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_roles',
                `ant_type` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'd=todo,t=tile,s=search',
                `ant_section` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'if tile then only value expect',
                `ant_article_list` json NOT NULL,
                `ant_filter_list` json NOT NULL,
                `ant_posted_by` bigint(20) UNSIGNED NOT NULL,
                `ant_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `ant_posted_date` datetime NOT NULL,
                `ant_merge_date` datetime DEFAULT NULL,
                `ant_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
               PRIMARY KEY (`ant_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
              DB::statement("ALTER TABLE `rvw_article_next_task` ADD INDEX(`ant_usr_id`)");
              DB::statement("ALTER TABLE `rvw_article_next_task` ADD INDEX(`ant_jnl_id`)");
              DB::statement("ALTER TABLE `rvw_article_next_task` ADD INDEX(`ant_role_id`)");

              DB::statement("ALTER TABLE `rvw_article_next_task` ADD FOREIGN KEY (`ant_usr_id`) REFERENCES `rvw_users`(`usr_id`) ON DELETE CASCADE ON UPDATE CASCADE");
              DB::statement("ALTER TABLE `rvw_article_next_task` ADD FOREIGN KEY (`ant_jnl_id`) REFERENCES `rvw_journals`(`jnl_id`) ON DELETE CASCADE ON UPDATE CASCADE");
              DB::statement("ALTER TABLE `rvw_article_next_task` ADD FOREIGN KEY (`ant_role_id`) REFERENCES `rvw_roles`(`role_id`) ON DELETE CASCADE ON UPDATE CASCADE");
        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rvw_article_next_task');
    }
};
