<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        DB::beginTransaction();
        try {
            DB::statement("CREATE TABLE `rvw_article_classification` (
                `arcls_id` int(11) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
                `arcls_art_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
                `arcls_cls_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_classifications',
                `arcls_posted_date` datetime NOT NULL,
                `arcls_posted_by` bigint(20) NOT NULL COMMENT 'pk of rvw_user',
                `arcls_proxy_id` bigint(20) NOT NULL,
                `arcls_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
            DB::unprepared("
            CREATE TRIGGER `trg_article_classification_after_insert` AFTER INSERT ON `rvw_article_classification`
            FOR EACH ROW INSERT INTO tbk_article_classification SELECT *,NULL tbk_id FROM rvw_article_classification WHERE arcls_id= NEW.arcls_id
            ");
            DB::unprepared("
            CREATE TRIGGER `trg_article_classification_after_update` AFTER UPDATE ON `rvw_article_classification`
            FOR EACH ROW BEGIN IF (NEW.arcls_operation != 'm') 
                THEN 
                INSERT INTO tbk_article_classification SELECT *,NULL tbk_id FROM rvw_article_classification WHERE arcls_id= OLD.arcls_id;
                END IF;
                END
            ");
            DB::statement("ALTER TABLE `rvw_article_classification`
            ADD KEY `arcls_id` (`arcls_id`),
            ADD KEY `arcls_cls_id` (`arcls_cls_id`),
            ADD KEY `arcls_posted_by` (`arcls_posted_by`),
            ADD KEY `arcls_proxy_id` (`arcls_proxy_id`),
            ADD KEY `arcls_posted_by_2` (`arcls_posted_by`),
            ADD KEY `arcls_proxy_id_2` (`arcls_proxy_id`)
            ");

            DB::statement("ALTER TABLE `rvw_article_classification`
            ADD CONSTRAINT `rvw_article_classification_ibfk_3` FOREIGN KEY (`arcls_art_id`) REFERENCES `rvw_articles` (`art_id`) ON DELETE CASCADE ON UPDATE CASCADE,
            ADD CONSTRAINT `rvw_article_classification_ibfk_4` FOREIGN KEY (`arcls_cls_id`) REFERENCES `rvw_classifications` (`cls_id`) ON UPDATE CASCADE");

            DB::statement("CREATE TABLE `tbk_article_classification` (
                `arcls_id` int(11) UNSIGNED NOT NULL,
                `arcls_art_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
                `arcls_cls_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_classifications',
                `arcls_posted_date` datetime NOT NULL,
                `arcls_posted_by` bigint(20) NOT NULL COMMENT 'pk of rvw_user',
                `arcls_proxy_id` bigint(20) NOT NULL,
                `arcls_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                `tbk_id` bigint(20) UNSIGNED NOT NULL  PRIMARY KEY AUTO_INCREMENT
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");


        } catch (\Exception $e) {
            // DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_article_classification');
        Schema::drop('tbk_article_classification');
    }
};
