<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
 
        try
        {
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `rvw_stage_import_go_files` (
                    `sig_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                    `sig_file_name` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                    `sig_aflw_id` bigint UNSIGNED DEFAULT NULL,
                    `sig_status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'r' COMMENT 's-success import,f-failed import,r-repeat import',
                    `sig_message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT 'json data',
                    `sig_posted_by` bigint UNSIGNED NOT NULL,
                    `sig_posted_date` datetime NOT NULL,
                    `sig_proxy_id` bigint UNSIGNED NOT NULL,
                    `sig_operation` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    PRIMARY KEY (`sig_id`),
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;"
            );

            DB::statement("CREATE TABLE IF NOT EXISTS `tbk_stage_import_go_files` (
                    `sig_id` bigint UNSIGNED NOT NULL,
                    `sig_file_name` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                    `sig_aflw_id` bigint UNSIGNED DEFAULT NULL,
                    `sig_status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'r' COMMENT 's-success import,f-failed import,r-repeat import',
                    `sig_message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT 'json data',
                    `sig_posted_by` bigint UNSIGNED NOT NULL,
                    `sig_posted_date` datetime NOT NULL,
                    `sig_proxy_id` bigint UNSIGNED NOT NULL,
                    `sig_operation` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
               PRIMARY KEY (`tbk_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;");

            DB::statement("ALTER TABLE `rvw_stage_import_go_files` ADD INDEX(`sig_aflw_id`)");
            DB::unprepared("drop trigger if exists trg_stage_import_go_files_after_insert; CREATE TRIGGER trg_stage_import_go_files_after_insert  AFTER INSERT ON rvw_stage_import_go_files FOR EACH ROW INSERT INTO tbk_stage_import_go_files SELECT *,NULL tbk_id FROM rvw_stage_import_go_files WHERE sig_id= NEW.sig_id;");    
            
            DB::unprepared("drop trigger if exists trg_stage_import_go_files_after_update; CREATE TRIGGER trg_stage_import_go_files_after_update  AFTER UPDATE ON rvw_stage_import_go_files FOR EACH ROW INSERT INTO tbk_stage_import_go_files SELECT *,NULL tbk_id FROM rvw_stage_import_go_files WHERE sig_id= OLD.sig_id;");

        }
        catch(\Exception $e)
        {
          //  DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::drop("rvw_stage_import_go_files");
        Schema::drop("tbk_stage_import_go_files");
    }
};
