<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        /* Schema::create('rvw_user_classification', function (Blueprint $table) {
            $table->bigIncrements('usrcls_id');
            $table->bigInteger('usrcls_usr_id');
        }); */
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_user_classification` (
            `usrcls_id` int UNSIGNED NOT NULL,
            `usrcls_usr_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_users',
            `usrcls_cls_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_classifications',
            `usrcls_posted_by` bigint UNSIGNED NOT NULL,
            `usrcls_posted_date` datetime NOT NULL,
            `usrcls_proxy_id` bigint NOT NULL,
            `usrcls_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
        DB::statement("ALTER TABLE `rvw_user_classification`
            MODIFY `usrcls_id` int UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT, AUTO_INCREMENT=3394;
        ");

        DB::statement("CREATE TABLE IF NOT EXISTS  `tbk_user_classification` (
            `usrcls_id` int UNSIGNED NOT NULL,
            `usrcls_usr_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_users',
            `usrcls_cls_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_classifications',
            `usrcls_posted_by` bigint UNSIGNED NOT NULL,
            `usrcls_posted_date` datetime NOT NULL,
            `usrcls_proxy_id` bigint NOT NULL,
            `usrcls_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
            `tbk_id` int UNSIGNED NOT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
        DB::statement("ALTER TABLE `tbk_user_classification`
            MODIFY `tbk_id` int UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT, AUTO_INCREMENT=3394;
        ");

        DB::unprepared('
            CREATE TRIGGER trg_user_classification_after_insert AFTER INSERT ON `rvw_user_classification` FOR EACH ROW
            BEGIN
            INSERT INTO tbk_user_classification SELECT *,NULL tbk_id FROM rvw_user_classification WHERE usrcls_id= NEW.usrcls_id;
            END
        ');
        DB::unprepared("
            CREATE TRIGGER trg_user_classification_after_update AFTER UPDATE ON `rvw_user_classification` FOR EACH ROW
            BEGIN
            IF (NEW.usrcls_operation != 'm') THEN INSERT INTO tbk_user_classification SELECT *,NULL tbk_id FROM rvw_user_classification WHERE usrcls_id= OLD.usrcls_id;
            END IF;
            END
        ");

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_user_classification');
        Schema::dropIfExists('tbk_user_classification');
    }
};
