<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try{
            DB::statement("DELETE from `migrations` where `migration` IN ('2024_01_30_133225_add_classification_selection_mode','2024_02_01_115408_alter_classification_selection_mode')");
            if (Schema::hasColumn('rvw_journal_settings', 'jset_classification_selection_mode')) {
                Schema::table('rvw_journal_settings', function (Blueprint $table) {
                    $table->dropColumn('jset_classification_selection_mode');
                });
            }
            if (Schema::hasColumn('tbk_journal_settings', 'jset_classification_selection_mode')) {
                Schema::table('tbk_journal_settings', function (Blueprint $table) {
                    $table->dropColumn('jset_classification_selection_mode');
                });
            }
            DB::statement("ALTER TABLE rvw_journal_settings ADD COLUMN jset_classification_selection_mode CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'p' COMMENT 'c = Child only, p = Parent and child, h = Selection without hieararchy' AFTER jset_classification_title");
            DB::statement("ALTER TABLE tbk_journal_settings ADD COLUMN jset_classification_selection_mode CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'p' COMMENT 'c = Child only, p = Parent and child, h = Selection without hieararchy' AFTER jset_classification_title");
            DB::statement("ALTER TABLE rvw_journal_settings ADD COLUMN jset_min_classification SMALLINT NOT NULL COMMENT 'Minimum Number of classifications' AFTER `jset_classification_selection_mode`, ADD COLUMN `jset_max_classification` INT NOT NULL COMMENT 'Minimum Number of classifications' AFTER `jset_min_classification`");
            DB::statement("ALTER TABLE tbk_journal_settings ADD COLUMN jset_min_classification SMALLINT NOT NULL COMMENT 'Minimum Number of classifications' AFTER `jset_classification_selection_mode`, ADD COLUMN `jset_max_classification` INT NOT NULL COMMENT 'Minimum Number of classifications' AFTER `jset_min_classification`");
        }
        catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_classification_selection_mode')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_classification_selection_mode');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_classification_selection_mode')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_classification_selection_mode');
            });
        }

        if (Schema::hasColumn('rvw_journal_settings', 'jset_min_classification')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_min_classification');
            });
        }
        if (Schema::hasColumn('rvw_journal_settings', 'jset_max_classification')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_max_classification');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_min_classification')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_min_classification');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_max_classification')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_max_classification');
            });
        }
    }
};
