<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->char('jset_tat_exclude_days')->default('i')->after('jset_submission_editor');
            $table->json('jset_tat_days_excluded')->nullable()->default(null)->after('jset_tat_exclude_days');
        });
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->char('jset_tat_exclude_days')->default('i')->after('jset_submission_editor');
            $table->json('jset_tat_days_excluded')->nullable()->default(null)->after('jset_tat_exclude_days');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->dropColumn(['jset_tat_exclude_days', 'jset_tat_days_excluded']);
        });
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->dropColumn(['jset_tat_exclude_days', 'jset_tat_days_excluded']);
        });
    }
};
