<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbk_clients', function (Blueprint $table) {
            $table->string('clnt_client_country', 50)->change();
        });

        Schema::table('rvw_clients', function (Blueprint $table) {
            $table->string('clnt_client_logo')->nullable()->after('clnt_client_country')->change();
        });

        Schema::table('tbk_clients', function (Blueprint $table) {
            $table->string('clnt_client_logo')->nullable()->after('clnt_client_country')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbk_clients', function (Blueprint $table) {
            $table->string('clnt_client_country', 2)->change();
        });

        Schema::table('rvw_clients', function (Blueprint $table) {
            $table->string('clnt_client_logo')->after('clnt_client_country')->nullable()->change();
        });

        Schema::table('tbk_clients', function (Blueprint $table) {
            $table->string('clnt_client_logo')->after('clnt_client_country')->nullable()->change();
        });
    }
};
