<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_types', 'artp_status'))
        {
            Schema::table('rvw_article_types', function (Blueprint $table) {
                $table->string('artp_status', 1)->default('y')->comment('yes:y,no:n');           
            });
        }
        if (!Schema::hasColumn('tbk_article_types', 'artp_status'))
        {
            Schema::table('tbk_article_types', function (Blueprint $table) {
                $table->string('artp_status', 1)->default('y')->comment('yes:y,no:n');           
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_types', 'phone'))
        {
            Schema::table('rvw_article_types', function (Blueprint $table) {
                $table->dropColumn('artp_status');           
            });
        }
    }
};
