<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("ALTER TABLE `rvw_journal_workflows` MODIFY `jwf_enable_payment` CHAR(1),ADD `jwf_payment_notes` varchar(255) NULL AFTER `jwf_payment_fees`;");
            DB::statement("ALTER TABLE `tbk_journal_workflows` MODIFY `jwf_enable_payment` CHAR(1),ADD `jwf_payment_notes` varchar(255) NULL AFTER `jwf_payment_fees`;");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_journal_workflows` DROP COLUMN `jwf_payment_notes`;");
        DB::statement("ALTER TABLE `tbk_journal_workflows` DROP COLUMN `jwf_payment_notes`;");
    }
};
