<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement("DELETE rvw_article_version_reviewers 
                FROM rvw_article_version_reviewers 
                JOIN (
                    SELECT artvr_id, GROUP_CONCAT(aflw_status) AS status
                    FROM rvw_article_version_reviewers 
                    JOIN rvw_article_flow ON (artvr_user_id = aflw_usr_id and aflw_art_id IN(IF(artvr_previous_art_ids IS NOT NULL,artvr_previous_art_ids,artvr_article_id)))
                    JOIN rvw_journal_workflows ON aflw_jwf_id = jwf_id
                    WHERE jwf_stage_type = 'review'
                    GROUP BY artvr_id
                ) AS tb1 ON rvw_article_version_reviewers.artvr_id = tb1.artvr_id
                WHERE FIND_array_not_in('i,a,c', tb1.status) = 1;");
        }
        catch(\Exception $e)
        {
            DB::rollback();
            print_r($e);exit;
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
