<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_workflows', 'jwf_prevent_edit'))
        {
            Schema::table('rvw_journal_workflows', function (Blueprint $table) {
                $table->char('jwf_prevent_edit', 1)->after('jwf_payment_notes')->default('n');        
            });
        }
        if (!Schema::hasColumn('tbk_journal_workflows', 'jwf_prevent_edit'))
        {
            Schema::table('tbk_journal_workflows', function (Blueprint $table) {
                $table->char('jwf_prevent_edit', 1)->after('jwf_payment_notes')->default('n');              
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasColumn('rvw_journal_workflows', 'jwf_prevent_edit'))
        {
            Schema::table('rvw_journal_workflows', function (Blueprint $table) {
                $table->dropColumn('jwf_prevent_edit');        
            });
        }
        if (!Schema::hasColumn('tbk_journal_workflows', 'jwf_prevent_edit'))
        {
            Schema::table('tbk_journal_workflows', function (Blueprint $table) {
                $table->dropColumn('jwf_prevent_edit');            
            });
        }
    }
};
