<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       try{
            DB::statement(
                "CREATE TABLE `tbk_article_autoinvitation_emails` (
                    `aae_id` bigint UNSIGNED NOT NULL,
                    `aae_usr_id` bigint unsigned NOT NULL,
                    `aae_stage_etmp_id` bigint NOT NULL,
                    `aae_art_id` bigint unsigned NOT NULL,
                    `aae_aflw_id` bigint unsigned DEFAULT NULL,
                    `aae_auap_id` bigint unsigned NOT NULL,
                    `aae_afap_id` bigint unsigned NOT NULL,
                    `aae_template_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_action` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_to` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_cc` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_bcc` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_subject` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_content` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_cust_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_cust_cc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_cust_bcc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `aae_reply_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `ane_updated_date` datetime DEFAULT NULL,
                    `ane_setr_id` bigint unsigned NOT NULL,
                    `aae_status` int NOT NULL COMMENT '1 - send',
                    `aae_posted_date` datetime NOT NULL,
                    `aae_posted_by` bigint NOT NULL,
                    `aae_proxy_id` bigint NOT NULL,
                    `aae_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    PRIMARY KEY (`tbk_id`)
                  ) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::unprepared("drop trigger if exists trg_article_autoinvitation_emails_after_insert; CREATE TRIGGER trg_article_autoinvitation_emails_after_insert  AFTER INSERT ON rvw_article_autoinvitation_emails FOR EACH ROW INSERT INTO tbk_article_autoinvitation_emails SELECT *,NULL tbk_id FROM rvw_article_autoinvitation_emails WHERE aae_id= NEW.aae_id;");    
            
            DB::unprepared("drop trigger if exists trg_article_autoinvitation_emails_after_update; CREATE TRIGGER trg_article_autoinvitation_emails_after_update  AFTER UPDATE ON rvw_article_autoinvitation_emails FOR EACH ROW INSERT INTO tbk_article_autoinvitation_emails SELECT *,NULL tbk_id FROM rvw_article_autoinvitation_emails WHERE aae_id= OLD.aae_id;");
       }
       catch(\Exception $e)
       {
           print_r($e);die;
         //  DB::rollback();
       }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop("tbk_article_autoinvitation_emails");
    }
};
