<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_custom_reasons', 'cusr_status'))
        {
            Schema::table('rvw_article_custom_reasons', function (Blueprint $table) {
                $table->char('cusr_status', 1)->after('cusr_reason')->comment('p:pending,a:approve,r:reject')->nullable();      
            });
        }
        if (!Schema::hasColumn('tbk_article_custom_reasons', 'cusr_status'))
        {
            Schema::table('tbk_article_custom_reasons', function (Blueprint $table) {
                $table->char('cusr_status', 1)->after('cusr_reason')->comment('p:pending,a:approve,r:reject')->nullable();             
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_custom_reasons', 'jp_prevent_edit'))
        {
            Schema::table('rvw_article_custom_reasons', function (Blueprint $table) {
                $table->dropColumn('jp_prevent_edit');        
            });
        }
        if (Schema::hasColumn('tbk_journal_permission', 'jp_prevent_edit'))
        {
            Schema::table('tbk_journal_permission', function (Blueprint $table) {
                $table->dropColumn('jp_prevent_edit');              
            });
        }
    }
};
