<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            if (!Schema::connection('mysql_common')->hasIndex('rvw_faqs','faq_search_key')) {
                DB::connection('mysql_common')->statement('ALTER TABLE rvw_faqs ADD FULLTEXT faq_search_key (faq_question,faq_answer,faq_tags)');
            }
        } catch (\Exception $e) {
            throw new \Exception($e->getTraceAsString());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::connection('mysql_common')->statement('ALTER TABLE `rvw_faqs` DROP INDEX `faq_search_key`');
    }
};
