<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_note_subtask');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_note_subtask', function (Blueprint $table) {
            $table->id('subtask_id');
            $table->integer('subtask_note_id', false, true)->comment('pk of rvw_note_subtask');
            $table->string('subtask_title', 1000);
            $table->unsignedBigInteger('subtask_posted_by');
            $table->dateTime('subtask_posted_date');
            $table->unsignedBigInteger('subtask_proxy_id')->nullable();
            $table->char('subtask_operation', 1);
        });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_note_subtask');
    }
};
