<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::connection('mysql_common')->hasTable('rvw_release_notes')) {
            if (!Schema::connection('mysql_common')->hasColumn('rvw_release_notes', 'note_date'))
            {
              
            Schema::connection('mysql_common')->table('rvw_release_notes', function (Blueprint $table) {
                // Example: Adding a new column to the table
                $table->dateTime('note_date')->after('note_category')->nullable();
            });
              }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::connection('mysql_common')->hasTable('rvw_release_notes')) {
            if (!Schema::hasColumn('rvw_release_notes', 'note_date'))
            {
            Schema::connection('mysql_common')->table('rvw_release_notes', function (Blueprint $table) {
                // Example: Adding a new column to the table
                $table->dateTime('note_date')->after('note_category')->nullable();
            });
            }
        }
    }
};
