<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->json('jset_batch_reviews')->after('jset_batch_decision')->nullable();
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->json('jset_batch_reviews')->after('jset_batch_decision')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_reviews');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_reviews');
            });
        }
    }
};
