<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Http\Controllers\Dbmanagement\Manage_Database;
use Illuminate\Support\Facades\Log;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_api_credentials', 'acrd_eula'))
            {
                Schema::table('rvw_api_credentials', function (Blueprint $table) {
                    $table->char('acrd_eula', 1)->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->nullable()->comment('y- yes, n-no , end user license agreement')->after('acrd_key');

                    $table->json('acrd_ith_v2_view_settings')->nullable()->comment('ith_v2 view settings options')->after('acrd_eula');

                    $table->json('acrd_ith_v2_add_to_index')->nullable()->comment('ith_v2 indexing_settings options')->after('acrd_ith_v2_view_settings');

                    $table->json('acrd_ith_v2_save_changes')->nullable()->comment('ith_v2 indexing_settings options')->after('acrd_ith_v2_add_to_index');

                    $table->unsignedSmallInteger('acrd_ex_mch_cnt')->comment('if exclude_small_matches = true then only value expect greater than 8')->after('acrd_ith_v2_save_changes');
                });
            }

            (new Manage_Database())->updateiThenticateConfig();

            //here delete journal settings resp. columns
            if (Schema::hasColumn('rvw_journal_settings', 'jset_eula')){
                Schema::table('rvw_journal_settings', function (Blueprint $table) {
                    $table->dropColumn([
                        'jset_eula',
                        'jset_ith_v2_view_settings',
                        'jset_ith_v2_add_to_index',
                        'jset_ith_v2_save_changes'
                    ]);
                });
            }
            if (Schema::hasColumn('rvw_article_type_advance_options', 'atotp_eula')){
                Schema::table('rvw_article_type_advance_options', function (Blueprint $table) {
                    $table->dropColumn([
                        'atotp_eula',
                        'atotp_ith_v2_view_settings',
                        'atotp_ith_v2_add_to_index',
                        'atotp_ith_v2_save_changes'
                    ]);
                });
            }
            //here delete article type advances option columns
        }
        catch(\Exception $e)
        {
            Log::warning("updateiThenticateConfig failed");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_api_credentials', 'acrd_eula')){
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn([
                    'acrd_eula',
                    'acrd_ith_v2_view_settings',
                    'acrd_ith_v2_add_to_index',
                    'acrd_ith_v2_save_changes',
                    'acrd_ex_mch_cnt'
                ]);
            });
        }
    }
};
