<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rvw_convey_data', function (Blueprint $table) {
            $table->id('rcd_id'); 
            $table->unsignedBigInteger('rcd_usr_id');
            $table->integer('rcd_art_id');
            $table->integer('rcd_discloser_list_id');
            $table->integer('rcd_discloser_id');
            $table->integer('rcd_disclosure_id')->nullable();
            $table->date('rcd_last_invited_date')->nullable();
            $table->enum('rcd_disclosure_cmpltn_status', ['i', 'p', 'c']) 
                  ->nullable()->default(null);
            $table->integer('rcd_posted_by');
            $table->date('rcd_posted_date');
            $table->integer('rcd_proxy_id')->nullable();
            $table->enum('rcd_operation', ['i', 'd', 'u']); 
            $table->foreign('rcd_usr_id')->references('usr_id')->on('rvw_users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_convey_data');
    }
};
