<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Alter the rvw_email_tmpls table
        if (!Schema::hasColumn('rvw_email_tmpls', 'etmp_remind_days')) {
            Schema::table('rvw_email_tmpls', function (Blueprint $table) {
                $table->integer('etmp_remind_days')
                    ->nullable()
                    ->default(0)
                    ->after('etmp_email_template')
                    ->comment('send reminder for every input days');
            });
        }

        // Alter the tbk_email_tmpls table
        if (!Schema::hasColumn('tbk_email_tmpls', 'etmp_remind_days')) {
            Schema::table('tbk_email_tmpls', function (Blueprint $table) {
                $table->integer('etmp_remind_days')
                    ->nullable()
                    ->default(0)
                    ->after('etmp_email_template')
                    ->comment('send reminder for every input days');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Drop the column from rvw_email_tmpls table
         if (Schema::hasColumn('rvw_email_tmpls', 'etmp_remind_days')) {
            Schema::table('rvw_email_tmpls', function (Blueprint $table) {
                $table->dropColumn('etmp_remind_days');
            });
        }

        // Drop the column from tbk_email_tmpls table
        if (Schema::hasColumn('tbk_email_tmpls', 'etmp_remind_days')) {
            Schema::table('tbk_email_tmpls', function (Blueprint $table) {
                $table->dropColumn('etmp_remind_days');
            });
        }
    }
};
