<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('tbk_journal_settings', 'jset_eula')){
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn([
                    'jset_eula',
                    'jset_ith_v2_view_settings',
                    'jset_ith_v2_add_to_index',
                    'jset_ith_v2_save_changes'
                ]);
            });
        }
        if (Schema::hasColumn('tbk_article_type_advance_options', 'atotp_eula')){
            Schema::table('tbk_article_type_advance_options', function (Blueprint $table) {
                $table->dropColumn([
                    'atotp_eula',
                    'atotp_ith_v2_view_settings',
                    'atotp_ith_v2_add_to_index',
                    'atotp_ith_v2_save_changes'
                ]);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
