<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rvw_issue_final_upload_files', function (Blueprint $table) {
            $table->id('isfuf_id');
            $table->string('isfuf_iss_id');
            $table->string('isfuf_name');
            $table->string('isfuf_location', 500);
            $table->char('isfuf_export_status',1);
            $table->double('isfuf_size', 10,3);
            $table->unsignedBigInteger('isfuf_posted_by');
            $table->dateTime('isfuf_posted_date');
            $table->unsignedBigInteger('isfuf_proxy_id')->nullable();
            $table->char('isfuf_operation', 1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('issue_final_upload_files');
    }
};
