<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $etmpName = 'send_notification_to_user';

        // Check if the data already exists
        $existingRecord = DB::table('rvw_email_tmpls')
            ->where('etmp_name', $etmpName)
            ->first();

        if (!$existingRecord) {
            // Insert the new data
            DB::table('rvw_email_tmpls')->insert([
                'etmp_id' => NULL,
                'etmp_platform' => 'g',
                'etmp_name' => $etmpName,
                'etmp_templete_name' => '',
                'etmp_notification' => 'staff',
                'etmp_cust_to' => '',
                'etmp_cc' => '',
                'etmp_cust_cc' => '',
                'etmp_bcc' => '',
                'etmp_cust_bcc' => '',
                'etmp_content_type' => '',
                'etmp_subject' => 'Articles created',
                'etmp_email_template' => '<p>Dear ##RECIPIENT_FIRSTNAME## ##RECIPIENT_LASTNAME##,</p>\r\n<p>&nbsp;</p>\r\n<p>The articles have been created, and they&rsquo;re now ready for author assignment. Please take it from here and assign each article to the appropriate author. Let me know if you encounter any issues or need further clarification.</p>\r\n<p>Here is the conference:</p>\r\n<p>##ARTICLE_STATUS_LINK##</p>\r\n<p>&nbsp;</p>\r\n<p>##JOURNAL_NAME##</p>',
                'etmp_remind_days' => '0',
                'etmp_posted_date' => '2025-02-20 00:00:00',
                'etmp_posted_by' => '0',
                'etmp_proxy_id' => '0',
                'etmp_operation' => 'i',
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
          $etmpName = 'send_notification_to_user';

          DB::table('rvw_email_tmpls')
              ->where('etmp_name', $etmpName)
              ->delete();
    }
};
