<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    // TASK #69 contact us mail (task #8907)
    public function up(): void
    {
        // Check if the column does not exist before adding it
        if (!Schema::hasColumn('rvw_user_feedback', 'fd_bcc_email_id')) {
            Schema::table('rvw_user_feedback', function (Blueprint $table) {
                $table->string('fd_bcc_email_id', 250)
                      ->charset('utf8mb4')
                      ->collation('utf8mb4_unicode_ci')
                      ->nullable()
                      ->after('fd_cc_email_id');
            });
        }
    }

    public function down(): void
    {
        // Only drop the column if it exists
        if (Schema::hasColumn('rvw_user_feedback', 'fd_bcc_email_id')) {
            Schema::table('rvw_user_feedback', function (Blueprint $table) {
                $table->dropColumn('fd_bcc_email_id');
            });
        }
    }
};
