<?php

use App\Models\Flags;
use App\Models\User_global_flags;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $users = DB::table('rvw_users')->select('usr_id', 'usr_email')->get(); // Get all users
        $flag = Flags::where('flag_type', 's')
             ->where('flag_name', 'Personal email')
             ->where('flag_status', 'y')
             ->first(); // Using Eloquent


        $domains = config('emailCheckerConfig.domains');

        foreach ($users as $user) {
            $domain = substr(strrchr($user->usr_email, "@"), 1);
            $flagExists = DB::table('rvw_user_global_flags') // Replace with your actual table name
                ->where('ugf_user_id', $user->usr_id)
                ->where('ugf_flag_id', $flag->flag_id)
                ->exists();

            if (in_array($domain, $domains)) {
                if (!$flagExists) {
                    // Insert the flag
                    DB::table('rvw_user_global_flags')->insert([
                        'ugf_user_id' => $user->usr_id,
                        'ugf_flag_id' =>  $flag->flag_id,
                        'ugf_operation' => 'i',
                        'ugf_posted_date' => now(), // Or your desired date
                        // Add other required fields
                    ]);
                }
            } else {
                if ($flagExists) {
                    // Delete the flag
                    DB::table('rvw_user_global_flags')
                        ->where('ugf_user_id', $user->usr_id)
                        ->where('ugf_flag_id',  $flag->flag_id)
                        ->delete();
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $flag = Flags::where('flag_type', 's')->first();

        if ($flag) {
            User_global_flags::where('ugf_flag_id', $flag->flag_id)->delete();
        }
    }
};