<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_article_type_advance_options', 'atotp_research_integrity')) {
                DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_research_integrity` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'Y-enabled in journal, N-not enabled' AFTER `atotp_blind_articles`");
            }
            if (!Schema::hasColumn('tbk_article_type_advance_options', 'atotp_research_integrity')) {
                DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_research_integrity` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'Y-enabled in journal, N-not enabled' AFTER `atotp_blind_articles`");
            }
        }
        catch(\Exception $e)
        {
            Log::warning("Adding new column:atotp_research_integrity failed in article type settings table");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_type_advance_options', 'atotp_research_integrity')) {
            DB::statement("ALTER TABLE `rvw_article_type_advance_options` DROP `atotp_research_integrity`");
        }
        if (Schema::hasColumn('tbk_article_type_advance_options', 'atotp_research_integrity')) {
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` DROP `atotp_research_integrity`");
        }
    }
};
