<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateRvwUsersTriggers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared("
            CREATE TRIGGER `after_user_insert` AFTER INSERT ON `rvw_users`
            FOR EACH ROW
            BEGIN
                DECLARE usr_domain VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                DECLARE personal_domains TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                DECLARE is_personal BOOLEAN;
                DECLARE flag_id_val BIGINT;

                -- Extract the domain
                SET usr_domain = LOWER(SUBSTRING_INDEX(NEW.usr_email, '@', -1));

                -- Check if the domain is personal directly, explicit collation
                IF EXISTS (
                    SELECT 1
                    FROM personal_email_domains
                    WHERE domain = usr_domain COLLATE utf8mb4_unicode_ci
                ) THEN
                    SET is_personal = TRUE;
                ELSE
                    SET is_personal = FALSE;
                END IF;

                -- Get the flag_id, explicit collation
                SELECT flag_id INTO flag_id_val
                FROM rvw_flags
                WHERE flag_type = 's' COLLATE utf8mb4_unicode_ci AND flag_name = 'Personal email' COLLATE utf8mb4_unicode_ci AND flag_status = 'y' COLLATE utf8mb4_unicode_ci
                LIMIT 1;

                -- Insert into rvw_user_global_flags if personal
                IF is_personal AND flag_id_val IS NOT NULL THEN
                    -- Insert if not exists
                    IF NOT EXISTS (SELECT 1 FROM rvw_user_global_flags WHERE ugf_user_id = NEW.usr_id AND ugf_flag_id = flag_id_val) THEN
                        INSERT INTO rvw_user_global_flags (ugf_user_id, ugf_flag_id, ugf_operation, ugf_posted_date, ugf_posted_by, ugf_proxy_id)
                        VALUES (NEW.usr_id, flag_id_val, 'i', NOW(), NEW.usr_posted_by, NEW.usr_proxy_id);
                    END IF;
                END IF;
            END;
        ");

        DB::unprepared("

            CREATE TRIGGER `after_user_update` AFTER UPDATE ON `rvw_users`
            FOR EACH ROW
            BEGIN
                -- DECLARE statements MUST be at the BEGINNING of the BEGIN ... END block
                DECLARE usr_domain VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                DECLARE personal_domains TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                DECLARE is_personal BOOLEAN;
                DECLARE flag_id_val BIGINT;
                DECLARE ugf_id_val BIGINT;

                IF OLD.usr_email <> NEW.usr_email THEN
                    -- Extract the domain
                    SET usr_domain = LOWER(SUBSTRING_INDEX(NEW.usr_email, '@', -1));

                    -- Check if the domain is personal directly, explicit collation
                    IF EXISTS (
                        SELECT 1
                        FROM personal_email_domains
                        WHERE domain = usr_domain COLLATE utf8mb4_unicode_ci
                    ) THEN
                        SET is_personal = TRUE;
                    ELSE
                        SET is_personal = FALSE;
                    END IF;

                    -- Get the flag_id, explicit collation
                    SELECT flag_id INTO flag_id_val
                    FROM rvw_flags
                    WHERE flag_type = 's' COLLATE utf8mb4_unicode_ci AND flag_name = 'Personal email' COLLATE utf8mb4_unicode_ci AND flag_status = 'y' COLLATE utf8mb4_unicode_ci
                    LIMIT 1;

                    -- Get the ugf_id, explicit collation
                    SELECT ugf_id INTO ugf_id_val
                    FROM rvw_user_global_flags
                    WHERE ugf_user_id = NEW.usr_id AND ugf_flag_id = flag_id_val
                    LIMIT 1;

                    -- Update rvw_user_global_flags
                    IF is_personal THEN
                        -- Insert if not exists
                        IF NOT EXISTS (SELECT 1 FROM rvw_user_global_flags WHERE ugf_user_id = NEW.usr_id AND ugf_flag_id = flag_id_val) THEN
                            INSERT INTO rvw_user_global_flags (ugf_user_id, ugf_flag_id, ugf_operation, ugf_posted_date, ugf_proxy_id, ugf_posted_by)
                            VALUES (NEW.usr_id, flag_id_val, 'i', NOW(), NEW.usr_proxy_id, NEW.usr_posted_by);
                        END IF;
                    ELSE
                        -- Delete if exists
                        IF ugf_id_val IS NOT NULL THEN
                            INSERT INTO tbk_user_global_flags (ugf_id, ugf_user_id, ugf_flag_id, ugf_operation, ugf_posted_date, ugf_posted_by, ugf_proxy_id)
                            VALUES (ugf_id_val, NEW.usr_id, flag_id_val, 'd', NOW(), NEW.usr_posted_by, NEW.usr_proxy_id);
                        END IF;
                        DELETE FROM rvw_user_global_flags WHERE ugf_user_id = NEW.usr_id AND ugf_flag_id = flag_id_val;
                    END IF;
                END IF;
            END;
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER IF EXISTS `after_user_insert`;');
        DB::unprepared('DROP TRIGGER IF EXISTS `after_user_update`;');
    }
}