<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement("ALTER TABLE `rvw_article_pdf` CHANGE `pdf_ith_document_id` `pdf_ith_document_id` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'id from ithenticate';");
            DB::statement("ALTER TABLE `tbk_article_pdf` CHANGE `pdf_ith_document_id` `pdf_ith_document_id` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'id from ithenticate';");

            DB::statement("ALTER TABLE `rvw_article_pdf` ADD `pdf_ith_similarity_response` JSON NULL DEFAULT NULL COMMENT 'version 2 response' AFTER `pdf_word_count`;");
            DB::statement("ALTER TABLE `tbk_article_pdf` ADD `pdf_ith_similarity_response` JSON NULL DEFAULT NULL COMMENT 'version 2 response' AFTER `pdf_word_count`;");
            DB::statement("UPDATE `rvw_article_pdf` SET `pdf_ith_document_id` =  NULL  WHERE pdf_ith_document_id = 0;");
            DB::statement("UPDATE `tbk_article_pdf` SET `pdf_ith_document_id` =  NULL  WHERE pdf_ith_document_id = 0;");

            DB::statement("ALTER TABLE `rvw_article_pdf` CHANGE `pdf_ith_report_url` `pdf_ith_report_url` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL, CHANGE `pdf_ith_view_only_url` `pdf_ith_view_only_url` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;");
            DB::statement("ALTER TABLE `tbk_article_pdf` CHANGE `pdf_ith_report_url` `pdf_ith_report_url` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL, CHANGE `pdf_ith_view_only_url` `pdf_ith_view_only_url` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;");

        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
