<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->dateTime('jset_conf_duedate')->nullable()->after('jset_rvriauto_submissions')->comment('date format = YYYY-mm-dd');
        });

        // For tbk_article_type_advance_options table
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->dateTime('jset_conf_duedate')->nullable()->after('jset_rvriauto_submissions')->comment('date format = YYYY-mm-dd');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_conf_duedate');
        });

        // Drop column from tbk_article_type_advance_options table
        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->dropColumn('jset_conf_duedate');
        });
    }
};
