<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Config;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        /*Task #1897 Seperate email template for invitation of organizers */
        // Check if VITE_CONFERENCE_PROCEEDINGS is set and true
        $isConferenceProceedingsEnabled = env('VITE_CONFERENCE_PROCEEDINGS', false);

        if (!$isConferenceProceedingsEnabled) {
            return; // Skip the migration if the condition is not met
        }
        $etmpName = 'send_notification_to_organiser';

        $existingRecord = DB::table('rvw_email_tmpls')
        ->where('etmp_name', $etmpName)
        ->first();

        if (!$existingRecord){
            DB::table('rvw_email_tmpls')->insert([
                'etmp_id' => NULL,
                'etmp_platform' => 'g',
                'etmp_name' => $etmpName,
                'etmp_templete_name' => 'Conference invitation',
                'etmp_notification' => 'User',
                'etmp_cust_to' => '',
                'etmp_cc' => '',
                'etmp_cust_cc' => '',
                'etmp_bcc' => '',
                'etmp_cust_bcc' => '',
                'etmp_content_type' => '',
                'etmp_subject' => 'Invitation to AIPP journal - ##INVITED_JOURNAL_NAME##',
                'etmp_email_template' => '<p>Dear ##RECIPIENT_FIRSTNAME## ##RECIPIENT_LASTNAME##,</p>
<p>&nbsp;</p>
<p>You have been invited to the&nbsp;role(s) ##INVITED_JOURNAL_ROLES## for AIPP Publishing journal, <em>##INVITED_JOURNAL_NAME##</em>.</p>
<p>Kindly complete the submission by ##ARTICLE_CREATION_DUE_DATE## to ensure timely processing.</p>
<p>&nbsp;</p>
<p>Regards,</p>
<p>ReView</p>',
                'etmp_remind_days' => '0',
                'etmp_posted_date' => '2025-05-21 00:00:00',
                'etmp_posted_by' => '0',
                'etmp_proxy_id' => '0',
                'etmp_operation' => 'i',
            ]);
        }

        //
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $isConferenceProceedingsEnabled = env('VITE_CONFERENCE_PROCEEDINGS', false);

        if (!$isConferenceProceedingsEnabled) {
            return; // Skip the migration if the condition is not met
        }
        $etmpName = 'send_notification_to_organiser';
        DB::table('rvw_email_tmpls')
              ->where('etmp_name', $etmpName)
              ->delete();
    }
    /*end Task #1897 Seperate email template for invitation of organizers */
};
