<?php
$config['dashboard'] = array(
	'author' => array(
		'Tiles' => array(
                    //#389 Add Submit article button to tile for author
			array(
				'title_singular' => 'Start submission',
				'title_plural' => 'Start submission',
				'color_class' => 'bg-green',
				'color'=>'#00a65a',
				'icon' => 'fa fa-upload',
				'function' => 'manage_draft',
				'section_id' => 'submit_article_tile',
				'count' => '',
				'page_url' => '',
				'view_mode' => '',
				'second_ajax' =>FALSE,
				'stage_type' =>array('author_submission')
			),
			array(
				'title_singular' => 'Task needing my attention',
				'title_plural' => 'Tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => '',
				'section_id' => 'manuscript-to-confirmation',
				'count' => 0,
				'page_url' => '',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
		),
			array(
				'title_singular' => 'Invitation',
				'title_plural' => 'Invitations',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'article_invite',
				'count' => 0,
				'page_url' => 'article-bulkinvitation',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('author_submission'),
				'hide_when_zero'=> true
			),
			array(
				'title_singular' => 'Submissions to complete',
				'title_plural' => 'Submissions to complete',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_draft',
				'section_id' => 'manage-draft',
				'count' => 0,
				'page_url' => 'drafts',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('author_submission')
			),
			/*array(
				'title_singular' => 'Under review',
				'title_plural' => 'Under review',
				'description' => 'His submitted articles in pre review and review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_peer_review',
				'section_id' => 'manage-peer-review',
				'count' => 0,
				'page_url' => 'awaiting-peerreview',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('staff_check','pre_assessment','review')
			),*/
			array(
				'title_singular' => 'Decision pending',
				'title_plural' => 'Decision pending',
				'title' => 'Pending decision',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('post_assessment','accept','reject','decision_revision')
			),
			array(
				'title_singular' => 'Start revised submission',
				'title_plural' => 'Start revised submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_awaiting_revision',
				'section_id' => 'manage-awaiting-revision',
				'count' => 0,
				'page_url' => 'awaiting-revision',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('revision','resubmission')

			),
			/*array(
				'title_singular' => 'Review completed',
				'title_plural' => 'Reviews completed',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_review_complete',
				'section_id' => 'manage-review-complete',
				'count' => 0,
				'page_url' => 'review-complete',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array('accept','reject','license_check','production')
			),*/
			array(
				'title_singular' => 'Copyright - to complete',
				'title_plural' => 'Copyright - to complete',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_copyright_complete',
				'section_id' => 'manage-copyright-complete',
				'count' => 0,
				'page_url' => 'copyright-complete',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('copyright'),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'Manuscript I\'ve co-authored',
				'title_plural' => 'Manuscripts I\'ve co-authored',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_co_author',
				'section_id' => 'manage-coauthor',
				'count' => 0,
				'page_url' => 'co-author',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array()
			),
			array(
				'title_singular' => 'BioRxiv submission',
				'title_plural' => 'BioRxiv submissions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_biorxiv',
				'section_id' => 'manage-biorxiv',
				'count' => 0,
				'page_url' => 'BioRxiv-submissions',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array()

			),
				array(
			    'title_singular' => 'To Proofread',
				'title_plural' => 'To Proofread',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'proofcheck',
				'count' => 0,
				'page_url' => 'proofcheck',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array('proof_reading'),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'Amendment required',
				'title_plural' => 'Amendment required',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_production_amendment',
				'section_id' => 'manage-production-amendment',
				'count' => 0,
				'page_url' => 'manage_production_amendment',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array(),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_completed_task',
				'section_id' => 'manage-completed-task',
				'count' => 0,
				'page_url' => 'management-completed',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array(),
				'hide_when_zero'=>true
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array(),
				'hide_when_zero'=>true
			),

		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>FALSE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => TRUE,
		'Map' => FALSE,
		'Enable_sort'=>FALSE,
		'Legacy_data'=>TRUE,
		'production_management'=>FALSE,
		'Withdrawn'=>TRUE
	),
	'editor_in_chief' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'New submission to assess',
				'title_plural' => 'New submissions to assess',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-file-text-o',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_new_manuscript',
				'section_id' => 'manage-new-manuscript',
				'count' => 0,
				'page_url' => 'new-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment")
			),
			/*array(
				'title_singular' => 'Select & invite reviewers',
				'title_plural' => 'Select & invite reviewers',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-user-o',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_select_invite_reviewer',
				'section_id' => 'select-invite-reviewer',
				'count' => 0,
				'page_url' => 'select-invite-reviewer',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),*/
			/*array(
				'title_singular' => 'Awaiting reviews',
				'title_plural' => 'Awaiting reviews',
				'description' => ':Articles in pre review and review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_reviewer_score',
				'section_id' => 'manage-reviewer-score',
				'count' => 0,
				'page_url' => 'reviewer-score',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),*/
			array(
				'title_singular' => 'Awaiting my decision',
				'title_plural' => 'Awaiting my decision',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('post_assessment','accept','reject','decision_revision')
			),
			array(
				'title_singular' => 'Assess revised submissions',
				'title_plural' => 'Assess revised submissions',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_revised_manuscript',
				'section_id' => 'manage_revised_manuscript',
				'count' => 0,
				'page_url' => 'revised-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment","revision","resubmission")
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_completed_task',
				'section_id' => 'manage-completed-task',
				'count' => 0,
				'page_url' => 'management-completed',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),
			/*array(
				'title_singular' => 'Review completed',
				'title_plural' => 'Reviews completed',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_review_complete',
				'section_id' => 'manage-review-complete',
				'count' => 0,
				'page_url' => 'review-complete',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' => array()
			),*/
			array(
				'title_singular' => 'Accepted for production',
				'title_plural' => 'Accepted for production',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_export_to_production',
				'section_id' => 'manage-export-to-production',
				'count' => 0,
				'page_url' => 'manage-export-to-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array(),
				'hide_when_zero'=>true
			),
			
			array(
				'title_singular' => 'Production tasks needing my attention',
				'title_plural' => 'Production tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'copy_editor_ready_production',
				'count' => 0,
				'page_url' => 'copy-editor-ready-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("copy_editing"),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'My overdue task',
				'title_plural' => 'My overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array(),
				'hide_when_zero'=>true
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>TRUE,
		'production_management'=>FALSE,
		'Withdrawn'=>FALSE
	),
	'associate_editor' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'New submissions to assess',
				'title_plural' => 'New submissions to assess',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_new_manuscript',
				'section_id' => 'manage-new-manuscript',
				'count' => 0,
				'page_url' => 'new-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment")
			),
			/*array(
				'title_singular' => 'Select & invite reviewer',
				'title_plural' => 'Select & invite reviewers',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_select_invite_reviewer',
				'section_id' => 'select-invite-reviewer',
				'count' => 0,
				'page_url' => 'select-invite-reviewer',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array()
			),*/
			array(
				'title_singular' => 'Pending reviewers',
				'title_plural' => 'Pending reviewers',
				'description' => 'Review accepted by reviewers (a) or invitation not accepted still',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_pending_review',
				'section_id' => 'manage-pending-review',
				'count' => 0,
				'page_url' => 'overdue-reviewers',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type'=>array('review'),
				'hide_when_zero'=>true
			),
			/*array(
				'title_singular' => 'Awaiting reviews',
				'title_plural' => 'Awaiting reviews',
				'description' => ':Articles in pre review and review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-clock-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_reviewer_score',
				'section_id' => 'manage-reviewer-score',
				'count' => 0,
				'page_url' => 'reviewer-score',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),*/
			array(
				'title_singular' => 'Awaiting my decision',
				'title_plural' => 'Awaiting my decision',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type'=>array('post_assessment','accept','reject','decision_revision')
			),
			array(
				'title_singular' => 'Revisions to assess',
				'title_plural' => 'Revisions to assess',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_revised_manuscript',
				'section_id' => 'manage_revised_manuscript',
				'count' => 0,
				'page_url' => 'revised-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment","revision","resubmission")
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_completed_task',
				'section_id' => 'manage-completed-task',
				'count' => 0,
				'page_url' => 'management-completed',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),
			array(
				'title_singular' => 'Accepted for production',
				'title_plural' => 'Accepted for production',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_export_to_production',
				'section_id' => 'manage-export-to-production',
				'count' => 0,
				'page_url' => 'manage-export-to-production',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type'=>array(),
				'hide_when_zero'=>true
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array(),
				'hide_when_zero'=>true
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>FALSE,
		'Withdrawn'=>FALSE
	),
	'staff' => array(
		'Tiles' => array(
			array(
				 //suggested by gijo
				'title_singular' => 'Check new submission',
				'title_plural' => 'Check new submissions',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_new_manuscript',
				'section_id' => 'manage-new-manuscript',
				'count' => 0,
				'page_url' => 'new-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment")
			),
			/*array(
				'title_singular' => 'Assign editor',
				'title_plural' => 'Assign editors',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_article_assignment',
				'section_id' => 'view-assignment',
				'count' => 0,
				'page_url' => 'view-assignment',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array()
			),*/
			/*array(
				'title_singular' => 'Under review',
				'title_plural' => 'Under review',
				'description' => ':Articles in pre review and review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'manage_peer_review',
				'section_id' => 'manage-peer-review',
				'count' => 0,
				'page_url' => 'awaiting-peerreview',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),*/
			array(
				'title_singular' => 'Task needing my attention',
				'title_plural' => 'Tasks needing my attention',
				'description' => '',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => '',
				'section_id' => 'manage-post-review',
				'count' => 0,
				'page_url' => '',
				'view_mode' => 'link',
				//'second_ajax' =>TRUE,
				'stage_type'=>array('copyright','license_check','payment','production'),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'Decision pending',
				'title_plural' => 'Decision pending',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('post_assessment','accept','reject','decision_revision')
			),
			array(
				'title_singular' => 'Check revised submission',
				'title_plural' => 'Check revised submissions',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_revised_manuscript',
				'section_id' => 'manage_revised_manuscript',
				'count' => 0,
				'page_url' => 'revised-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment","revision","resubmission")
			),
			array(
				'title_singular' => 'Review completed',
				'title_plural' => 'Reviews completed',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-link',
				'icon' => 'fa fa-info',
				'function' => 'manage_review_complete',
				'section_id' => 'manage-review-complete',
				'count' => 0,
				'page_url' => 'review-complete',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=> array('accept','reject','copyright','license_check','payment')
			),
			array(
				'title_singular' => 'Accepted for production',
				'title_plural' => 'Accepted for production',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-product-hunt',
				'icon' => 'fa fa-info',
				'function' => 'manage_export_to_production',
				'section_id' => 'manage-export-to-production',
				'count' => 0,
				'page_url' => 'manage-export-to-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array(),
				'hide_when_zero'=>true
			),
			
			array(
				'title_singular' => 'Production tasks needing my attention',
				'title_plural' => 'Production tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'copy_editor_ready_production',
				'count' => 0,
				'page_url' => 'copy-editor-ready-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array('editorial_amendment'),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_production_completed_task',
				'section_id' => 'manage-production-management-completed-task',
				'count' => 0,
				'page_url' => 'production-management-completed',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array(),
				'hide_when_zero'=>true
			),
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array(),
				'hide_when_zero'=>true
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
		'Enable_article_submit' => FALSE,
        'Overview_block'=> TRUE,
        'Lic_prod_pay_block'=>FALSE,
		'Map' => TRUE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>TRUE,
		'production_management'=>FALSE,
		'Withdrawn'=>FALSE
	),
	'journal_admin' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'Submissions awaiting check',
				'title_plural' => 'Submissions awaiting check',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-file-text-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_new_manuscript',
				'section_id' => 'manage-new-manuscript',
				'count' => 0,
				'page_url' => 'new-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment")
			),
			array(
				'title_singular' => 'Awaiting Editor assignment',
				'title_plural' => 'Awaiting Editor assignment',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-user-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_article_assignment',
				'section_id' => 'view-assignment',
				'count' => 0,
				'page_url' => 'view-assignment',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),
			/*array(
				'title_singular' => 'Under review',
				'title_plural' => 'Under review',
				'description' => ':Articles in review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-clock-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_peer_review',
				'section_id' => 'manage-peer-review',
				'count' => 0,
				'page_url' => 'awaiting-peerreview',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),*/
			array(
				'title_singular' => 'Decision pending',
				'title_plural' => 'Decision pending',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-info',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('post_assessment','accept','reject','decision_revision')
			),
			array(
				'title_singular' => 'Revisions awaiting check',
				'title_plural' => 'Revisions awaiting check',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-undo',
				'icon' => 'fa fa-info',
				'function' => 'manage_revised_manuscript',
				'section_id' => 'manage_revised_manuscript',
				'count' => 0,
				'page_url' => 'revised-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("staff_check","pre_assessment","revision","resubmission")

			),
			array(
				'title_singular' => 'Review completed',
				'title_plural' => 'Reviews completed',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-link',
				'icon' => 'fa fa-info',
				'function' => 'manage_review_complete',
				'section_id' => 'manage-review-complete',
				'count' => 0,
				'page_url' => 'review-complete',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=> array('accept','reject','copyright','license_check','payment','production')
			),
			array(
				'title_singular' => 'Accepted for production',
				'title_plural' => 'Accepted for production',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-product-hunt',
				'icon' => 'fa fa-info',
				'function' => 'manage_export_to_production',
				'section_id' => 'manage-export-to-production',
				'count' => 0,
				'page_url' => 'manage-export-to-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('production')
			),
			/*array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-info',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array()
			),*/
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
		),
        'event_dash' => array(
            array(
				'title_singular' => 'Submissions',
				'title_plural' => 'Submissions',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'ion fa fa-file',
				'function' => 'all-submission',
				'section_id' => 'all-submissions',
				'count' => 0,
                'sub_data' => [
                    [
                        'title' => 'Completed',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'green',
                        'count' => 0,
                        'function' => 'manage_all_manuscript',
				        'section_id' => 'manage-all-manuscript',
                        'hide_when_zero'=>false,
                        'stage_type' => array(),
                    ],
                    [
                        'title' => 'Inprogress',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'gray',
                        'count' => 0,
                        'function' => 'manage_draft',
                        'section_id' => 'manage-draft',
                        'stage_type' =>array('author_submission')
                    ]
                ],
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array(),
				'hide_when_zero'=>false,
				'callout' => 'callout-info',
			),
            /*array(
				'title_singular' => 'Under Review',
				'title_plural' => 'Under Review',
				'description' => ':Articles in pre review and review stage with ready/inprogress status',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'ion fa fa-clipboard-list',
				'function' => 'manage_peer_review_all',
				'section_id' => 'manage-peer-review-all',
				'count' => 0,
                'sub_data' => [
                    [
                        'title' => 'Completed',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'green',
                        'count' => 0,
                        'icon' => 'fa fa-info',
                        'function' => 'manage_review_all_complete',
                        'section_id' => 'manage-review-all-complete',
                        'stage_type' =>array('post_assessment','accept','reject','copyright','license_check','payment','production')
                    ],
                    [
                        'title' => 'Pending',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'gray',
                        'count' => 0,
                        'function' => 'manage_new_manuscript',
                        'section_id' => 'manage-new-manuscript-waiting',
                        'stage_type' =>array('staff_check','pre_assessment')
                    ]
                ],
				'page_url' => 'reviewer-score',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('staff_check','pre_assessment','review'),
				'callout' => 'callout-danger',
			),*/
            array(
				'title_singular' => 'Decision pending',
				'title_plural' => 'Decision pending',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'ion fa fa-clipboard-check',
				'function' => 'manage_awaiting_decision',
				'section_id' => 'manage-awaiting-decision',
				'count' => 0,
                'sub_data' => [
                    [
                        'title' => 'Accepted',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'green',
                        'count' => 0,
                        'function' => 'manage_export_to_production',
				        'section_id' => 'manage-export-to-production',
                        'hide_when_zero'=>false,
                        'stage_type' => array('accept', 'Production'),
                    ],
                    [
                        'title' => 'Rejected',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'gray',
                        'count' => 0,
                        'function' => 'manage_awaiting_decision',
				        'section_id' => 'manage-awaiting-decision',
                        'stage_type' =>array('reject')
                    ]
                ],
				'page_url' => 'awaiting-decision',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('post_assessment','decision_revision'),
				'callout' => 'callout-warning',
			),
            array(
				'title_singular' => 'Production',
				'title_plural' => 'Production',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'ion fa fa-exclamation',
				'function' => 'manage_export_to_production',
				'section_id' => 'manage-export-to-production',
				'count' => 0,
                'sub_data' => [
                    [
                        'title' => 'Pending for Production',
                        'color' => 'gray',
                        'icon' => 'ion fa fa-file',
                        'icon_color' => 'gray',
                        'count' => 0,
                        'function' => 'manage_awaiting_decision',
				        'section_id' => 'manage-awaiting-decision',
                        'stage_type' =>array('accept')
                    ]
                ],
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("production"),
				'callout' => 'callout-success',
			),

        ),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=> TRUE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => TRUE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>TRUE,
		'production_management'=>FALSE,
		'Withdrawn'=>FALSE
	),
	'reviewer' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'Invitations awaiting response',
				'title_plural' => 'Invitations awaiting response',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-users',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_invitation',
				'section_id' => 'manage-invitation',
				'count' => 0,
				'page_url' => 'invitation',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),
			array(
				'title_singular' => ':Articles to review',
				'title_plural' => ':Articles to review',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-eye',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_under_review',
				'section_id' => 'manage-under-review',
				'count' => 0,
				'page_url' => 'under-review',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),
			array(
				'title_singular' => 'Reviews submitted',
				'title_plural' => 'Reviews submitted',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_completed_task',
				'section_id' => 'manage-completed-task',
				'count' => 0,
				'page_url' => 'completed-task',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type'=>array('review')
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => 'Declined/unassigned article',
				'title_plural' => 'Declined/unassigned articles',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-info',
				'function' => '',
				'section_id' => 'declined-invitation',
				'count' => 0,
				'page_url' => '',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array('review')
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>TRUE,
		'production_management'=>FALSE,
		'Withdrawn'=>FALSE
	),
	'copy_editor' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'Tasks needing my attention',
				'title_plural' => 'Tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'copy_editor_ready_production',
				'count' => 0,
				'page_url' => 'copy-editor-ready-production',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("copy_editing")
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_production_completed_task',
				'section_id' => 'manage-production-management-completed-task',
				'count' => 0,
				'page_url' => 'production-management-completed',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("copy_editing")
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>TRUE,
		'Withdrawn'=>FALSE
	),
	'type_setter' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'Tasks needing my attention',
				'title_plural' => 'Tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'article_ready_production_manuscript',
				'count' => 0,
				'page_url' => 'article-ready-production-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("preprocessing","type_setting","postprocessing","publish")
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_production_completed_task',
				'section_id' => 'manage_production_completed_task',
				'count' => 0,
				'page_url' => 'manage-production-completed-task',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("preprocessing","type_setting","postprocessing","editorial_manage","publish")
			),
			array(
				'title_singular' => 'Ready for publication',
				'title_plural' => 'Ready for publication',
				'color_class' => 'bg-blue',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-newspaper-o',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_ready_publishing',
				'section_id' => 'manage_ready_publishing',
				'count' => 0,
				'page_url' => 'type-setter-article-ready-publish',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("editorial_manage","publish")
			),
			array(
				'title_singular' => 'To be initiated',
				'title_plural' => 'To be initiated',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-initiated',
				'count' => 0,
				'page_url' => 'to-be-initiated',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('qulity_check')
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>TRUE,
		'Withdrawn'=>FALSE
	),
	'proof_reader' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'Tasks needing my attention',
				'title_plural' => 'Tasks needing my attention',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-pencil-square-o',
				'icon' => 'fa fa-tasks',
				'function' => 'article_ready_production_manuscript',
				'section_id' => 'article-ready-production_manuscript',
				'count' => 0,
				'page_url' => 'article-ready-production_manuscript',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("proof_reading")
			),
			array(
				'title_singular' => 'My completed tasks',
				'title_plural' => 'My completed tasks',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-check-circle-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_production_completed_task',
				'section_id' => 'manage_production_completed_task',
				'count' => 0,
				'page_url' => 'proof-reader-completed-task',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("copy_editing","type_setting","editorial_manage","publish","proof_reading")
			),
			array(
				'title_singular' => 'Ready for publication',
				'title_plural' => 'Ready for publication',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-newspaper-o',
				'icon' => 'fa fa-info',
				'function' => 'manage_ready_publishing',
				'section_id' => 'manage_ready_publishing',
				'count' => 0,
				'page_url' => 'proof-reader-ready-to-publish',
				'view_mode' => 'link',
				'second_ajax' =>TRUE,
				'stage_type' =>array("editorial_manage")
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'second_ajax' => TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>FALSE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>TRUE,
		'Withdrawn'=>FALSE
	),
	'production_manager' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'My open task',
				'title_plural' => 'My open tasks',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'my-open-task',
				'count' => 0,
				'page_url' => 'my-open-task',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('qulity_check','aop_publish','editorial_amendment','pro_revision','editorial_process','preprocessing','graphic_processing','copy_editing','type_setting','proof_reading','postprocessing','publish')
			),
			array(
				'title_singular' => 'Bounced back',
				'title_plural' => 'Bounced back',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'bounced-back',
				'count' => 0,
				'page_url' => 'bounced-back',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('editorial_amendment','pro_revision')
			),
			array(
				'title_singular' => 'AoP1 to check',
				'title_plural' => 'AoP1 to check',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-check',
				'count' => 0,
				'page_url' => 'to-be-check',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('preprocessing')
			),
			array(
				'title_singular' => 'AoP2 in-progress',
				'title_plural' => 'AoP2 in-progress',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-submit-aop2-web-files-inprogress',
				'count' => 0,
				'page_url' => 'to-submit-aop2-web-files-inprogress',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('publish')
			),
			array(
				'title_singular' => 'AoP2 published',
				'title_plural' => 'AoP2 published',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-submit-aop2-web-files-completed',
				'count' => 0,
				'page_url' => 'to-submit-aop2-web-files-completed',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('publish')
			),
			array(
				'title_singular' => 'To be initiated',
				'title_plural' => 'To be initiated',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-initiated',
				'count' => 0,
				'page_url' => 'to-be-initiated',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('qulity_check')
			),
			array(
				'title_singular' => 'To be copyedited',
				'title_plural' => 'To be copyedited',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-copyedited',
				'count' => 0,
				'page_url' => 'to-be-copyedited',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('copy_editing')
			),
			array(
				'title_singular' => 'To be typeset',
				'title_plural' => 'To be typeset',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-typeset',
				'count' => 0,
				'page_url' => 'to-be-typeset',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('type_setting')
			),
			array(
				'title_singular' => 'Postprocessing',
				'title_plural' => 'Postprocessing',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'postprocessing',
				'count' => 0,
				'page_url' => 'postprocessing',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('postprocessing')
			),
			array(
				'title_singular' => 'Awaiting assignment',
				'title_plural' => 'Awaiting assignment',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_article_assignment',
				'section_id' => 'view-assignment',
				'count' => 0,
				'page_url' => 'view-assignment',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),
			
			array(
				'title_singular' => 'Open discussion',
				'title_plural' => 'Open discussions',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
//				'icon' => 'fa fa-balance-scale',
				'icon' => 'fa fa-tasks',
				'function' => 'open_generic_discussion',
				'section_id' => 'open-generic-discussion',
				'count' => 0,
				'page_url' => 'open-discussion',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'hide_when_zero'=>true,
				'stage_type'=>array()
			),
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>TRUE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>TRUE,
		'Withdrawn'=>FALSE
	),
	'tsp' => array(
		'Tiles' => array(
			array(
				'title_singular' => 'My open task',
				'title_plural' => 'My open tasks',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'my-open-task',
				'count' => 0,
				'page_url' => 'my-open-task',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('qulity_check','aop_publish','editorial_amendment','pro_revision','editorial_process','preprocessing','graphic_processing','copy_editing','type_setting','proof_reading','postprocessing','publish')
			),
			array(
				'title_singular' => 'To add to issue',
				'title_plural' => 'Add to issue',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
//				'icon' => 'fa fa-newspaper-o',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_ready_publishing',
				'section_id' => 'manage_ready_publishing',
				'count' => 0,
				'page_url' => 'manage-ready-publishing',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' =>TRUE,
				'stage_type' =>array("editorial_manage","publish","aop_publish")
			),
			array(
				'title_singular' => 'Bounced back',
				'title_plural' => 'Bounced back',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'bounced-back',
				'count' => 0,
				'page_url' => 'bounced-back',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('editorial_amendment','pro_revision')
			),
			array(
				'title_singular' => 'AoP2 in-progress',
				'title_plural' => 'AoP2 in-progress',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-submit-aop2-web-files-inprogress',
				'count' => 0,
				'page_url' => 'to-submit-aop2-web-files-inprogress',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('publish')
			),
			array(
				'title_singular' => 'AoP2 published',
				'title_plural' => 'AoP2 published',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-submit-aop2-web-files-completed',
				'count' => 0,
				'page_url' => 'to-submit-aop2-web-files-completed',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('publish')
			),
			array(
				'title_singular' => 'To be initiated',
				'title_plural' => 'To be initiated',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-initiated',
				'count' => 0,
				'page_url' => 'to-be-initiated',
				'view_mode' => 'link',
				'hide_when_zero'=> FALSE,
				'second_ajax' => TRUE,
				'stage_type' => array('qulity_check')
			),
			array(
				'title_singular' => 'Preprocessing',
				'title_plural' => 'Preprocessing',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'preprocessing',
				'count' => 0,
				'page_url' => 'preprocessing',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('preprocessing')
			),
			array(
				'title_singular' => 'File for correction',
				'title_plural' => 'Files for correction',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'files-for-correction',
				'count' => 0,
				'page_url' => 'files-for-correction',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('editorial_process')
			),
			array(
				'title_singular' => 'Awaiting assignment',
				'title_plural' => 'Awaiting assignment',
				'description' => 'permission wise assignment',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_article_assignment',
				'section_id' => 'view-assignment',
				'count' => 0,
				'page_url' => 'view-assignment',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' =>TRUE,
				'stage_type' =>array()
			),
			array(
				'title_singular' => 'To be copyedited',
				'title_plural' => 'To be copyedited',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-copyedited',
				'count' => 0,
				'page_url' => 'to-be-copyedited',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('copy_editing')
			),
			array(
				'title_singular' => 'To be typeset',
				'title_plural' => 'To be typeset',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-typeset',
				'count' => 0,
				'page_url' => 'to-be-typeset',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('type_setting')
			),
			array(
				'title_singular' => 'To be proofread',
				'title_plural' => 'To be proofread',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-be-proofread',
				'count' => 0,
				'page_url' => 'to-be-proofread',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('proof_reading')
			),
			array(
				'title_singular' => 'Postprocessing',
				'title_plural' => 'Postprocessing',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'document_for_tiles',
				'section_id' => 'postprocessing',
				'count' => 0,
				'page_url' => 'postprocessing',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('postprocessing')
			),
			array(
				'title_singular' => 'To submit AoP2 web file',
				'title_plural' => 'To submit AoP2 web files',
				'color_class' => 'bg-custom-info',
				'color'=>'#944b2a',
				'icon' => 'fa fa-info',
				'function' => 'document_for_tiles',
				'section_id' => 'to-submit-aop2-web-files',
				'count' => 0,
				'page_url' => 'to-submit-aop2-web-files',
				'view_mode' => 'link',
				'hide_when_zero'=> TRUE,
				'second_ajax' => TRUE,
				'stage_type' => array('publish')
			),
			
			array(
				'title_singular' => ':Articles under submission',
				'title_plural' => ':Articles under submission',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'articles_under_submission',
				'section_id' => 'articles-under-submission',
				'count' => 0,
				'page_url' => 'submitting-manuscript',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array("author_submission")
			),
			array(
				'title_singular' => 'All request',
				'title_plural' => 'All requests',
				'color_class' => 'bg-blue',
				'color'=>'#0073b7',
				'icon' => 'fa fa-tasks',
				'function' => 'all_request',
				'section_id' => 'all-request',
				'count' => 0,
				'page_url' => 'all-assigned-request',
				'view_mode' => 'link',
				'second_ajax' =>FALSE,
				'stage_type' =>array(),
				'hide_when_zero'=>true,
				'prevent_edit' => true
			),
			array(
				'title_singular' => 'Overdue task',
				'title_plural' => 'Overdue tasks',
				'color_class' => 'bg-red',
				'color'=>'#dd4b39',
				'icon' => 'fa fa-tasks',
				'function' => 'manage_overdue_task',
				'section_id' => 'manage-overdue-task',
				'count' => 0,
				'page_url' => 'overdue-task',
				'view_mode' => 'link',
				'view_priority' => 'secondary',
				'second_ajax' => TRUE,
				'hide_when_zero'=> TRUE,
				'stage_type' => array()
			),
		),
		'To_do' => TRUE,
		'Do_nut' => FALSE,
		'Latest_author'=>FALSE,
		'Enable_filter'=>TRUE,
        'Overview_block'=>TRUE,
        'Lic_prod_pay_block'=>FALSE,
		'Enable_article_submit' => FALSE,
		'Map' => FALSE,
		'Enable_sort'=>TRUE,
		'Legacy_data'=>FALSE,
		'production_management'=>TRUE,
		'Withdrawn'=>FALSE
	),
	'in_review'=>TRUE,  // has tile inreview
	'in_production'=>TRUE
);

$config['dashboard_overview_list'] = array(
	'ListItem' => array(
						array(
							 'title' => 'Reviews Overdue',
							 'page_url'   => 'review-overdue',
							 'function' => 'review_overdue',
							 'second_ajax' =>TRUE
						),
						array(
							 'title' => 'Invited Papers',
							 'page_url'   => 'pending-article-stubs',
							 'function' => 'pending_article_stubs',
							 'second_ajax' =>FALSE
						),
						 array(
							 'title' => 'Checked out articles',
							 'page_url'   => 'checked-out-articles',
							 'function' => 'checked_out_articles',
							 'second_ajax' =>FALSE
						),
						 array(
							 'title' => 'Awaiting reviewer selection/invitation',
							 'page_url'   => 'awaiting-reviewer-articles',
							 //'function' => 'awaiting_reviewer_articles',
							 'function' => 'awaiting_reviews',
							 'second_ajax' => TRUE
						),
						array(
							 'title' => 'Awaiting reviewer responses',
							 'page_url'   => 'awaiting-reviewer-responses',
							 //'function' => 'awaiting_reviewer_res_report_data',
							'function' => 'awaiting_reviews',
							 'second_ajax' =>TRUE
						),
						array(
							 'title' => 'Awaiting reviewer reports',
							 'page_url'   => 'awaiting-reviewer-reports',
							 //'function' => 'awaiting_reviewer_res_report_data',
							'function' => 'awaiting_reviews',
							'second_ajax' => TRUE
						)
					 )
);
// REST API for map
$config['dashboard_map'] = array(
'baseurl' => 'http://dev.virtualearth.net/REST/v1/Locations',
'key' => 'AmfOk2xwWNj5kqDse3LKuOZoCUtgYfV_DJ17G6j7ob3GespTDhcd2Z5H1_4zoGgM'
);

return $config;
