<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
       // $schedule->command('inspire')->hourly();
          $schedule->call('\App\Http\Controllers\Manage_Cron_Api@auto_decline_invitation')->dailyAt('04:00')->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@send_reminder')->dailyAt('04:00')->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@send_invitation_reminder')->dailyAt('04:00')->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@auto_review_close')->dailyAt('05:00')->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@autosubmit_to_ithenticate')->everyTenMinutes()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@repost_manuscript_data')->everyTwoHours()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@check_payment_status')->everyTwoHours()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@manage_pending_payments')->everyTwoHours()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@stage_import_files')->everySixHours()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@manage_receive_mail_responses')->everyTwoMinutes()->timezone(env('APP_TIMEZONE', 'America/New_York'))->name('manage_receive_mail_responses')->withoutOverlapping();
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@clear_similarityCheck_resulted_files')->weekly()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@iThenticateAwaitingTask')->everyThirtyMinutes()->timezone(env('APP_TIMEZONE', 'America/New_York'));//manage retry cron
        $schedule->call('\App\Http\Controllers\Manage_Cron_Api@autosubmit_to_rvri')->everyTenMinutes()->timezone(env('APP_TIMEZONE', 'America/New_York'));
        // $schedule->call('\App\Http\Controllers\Manage_Cron_Api@sendConveyDisclosureReminderCron')->dailyAt('04:00')->timezone(env('APP_TIMEZONE', 'America/New_York'));
        // $schedule->command('log:cron')
      // ->dailyAt('14:48')->timezone('Asia/Kolkata');

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
