<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ArticleStatusUpdate implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    public $connection = 'sync';

    /**
     * Create a new event instance.
     */
    public function __construct(
        public array $payload,
        protected $user_ids)
    {
        $link = $this->payload['link'] ?? null;
        $this->payload['link'] = $link ? url("/journal/$link") : url('/');
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return  collect($this->user_ids)->map(function ($user_id) {
            return new PrivateChannel("articlestatusupdate.". $user_id);
        })->toArray();
    }
}
